/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncssdsp.cpp,v 1.5 2005/02/23 04:40:23 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif
#ifdef WIN32
# include <conio.h>
#ifdef DSPTEC_EXTENSION
# include <io.h>
#endif
#endif
#include <fcntl.h>
#ifdef HAVE_SYSTYPES_H
#include <sys/types.h>
#endif

#include <stdio.h>
#include <math.h>

/* TODO check! */
/* this source code is a part of child process.. */
/* this process should be independence from the SATELLITE shell. */
/* this process must be initialize system common area. */
/*  because, get_tmpdir() and ChangeDataSize() use syscom */
#include "libsatellite.h"

#define MOD_NCS_LIBNCSS_EXTENSION
#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"
#include "ncssdata.h"
#include "ncssdsp.h"

#ifdef __cplusplus
extern "C" {
#endif

#define FCNTL_ERROR (-1)

#ifdef HARD_EXTENSION
#include   "FbiAd.h"
HANDLE      hDeviceHandle3163;
ADSMPLREQ   gConfig;
ADSMPLCHREQ gSmplChInf;
ADBOARDSPEC gInfo;
ULONG       gAdRange;
double      gAdScale;
#include "FbiDa.h"
HANDLE      hDeviceHandle3305;
DASMPLREQ   gConfig3305;
DASMPLCHREQ gSmplChInf3305;
DABOARDSPEC gInfo3305;
ULONG       gDaRange,gDaMode;
DAMODEREQ gModeConfig;
double      gDaScale;
#endif

#ifdef DSPTEC_EXTENSION
/*data*/
int	g_realtime_mode;
int g_realtime_disp;
int g_realtime_outport;
int g_calc_end_flag;
int	g_calc_cnt;
int         gScxfpType;
#define     START_EVENT_NAME	"rt_start_event"
#define     WAIT_EVENT_NAME		"rt_wait_event"
HANDLE      hStartEvent;
HANDLE      hWaitEvent;
#define     MAP_SIZE  256
#define     MAPPING_NAME  "rt-ncs"
HANDLE      hMapFile;
void       *MapPointer;
int         g_moni_size;

/*functions*/
void ncsl_ad3163open(FILE* fp);
void ncsl_ad3163close(FILE* fp);
void ncsl_da3305open(FILE* fp);
void ncsl_da3305close(FILE* fp);

double ncsl_sin( double amp, double freq, double phase, double dummy1, double dummy2 );
double ncsl_sweep( double start, double amp, double ifreq, double efreq, 
                   double dummy1 );
//double FunctionGenerator( double mode, double amp, 
//                          double freq, double phase );
//double StepFunction(double init_out, double start_tm, double height,
//                    double width, double period);
//int realtime_calculate_init(char* moni_vflag, int* index, double report_end, int calc_end);
//int realtime_calcucate_mode_check();
//int realtime_calculate_mode1();
//int realtime_calculate_mode2_init();
//int realtime_calculate_mode2_display(int calcnt, double time);
//int realtime_calculate_mode2_next();
//int realtime_calculation_open_mapfile();
//int realtime_calculation_close_mapfile();
//int realtime_calculate_mode2_wait();

#endif

#ifdef DSPTEC_EXTENSION
#define NCS_PRM_MAX 100
struct  scf_prm scData[NCS_PRM_MAX];

/*****************************************************************************
FUNCTION  NCSL_AD3163
******************************************************************************
AD3163 FUNCTION
  
                                     Coded by Y.Ozaki   12/11/2001
*****************************************************************************/

/*
 * Input data from A/D channel
 */
double ncsl_ad3163( double dch, double dummy2, double dummy3, double dummy4, double dummy5/*int ch*/ ){
#ifdef HARD_EXTENSION
  int    nRet;
  BYTE  bSmpData;
  WORD  wSmpData;
  DWORD  dwSmpData;
  double  out;
  int ch = (int)dch;

  gSmplChInf.ulChNo = ch;
  //gSmplChInf.ulRange = gConfig.SmplChReq[0].ulRange;
  gSmplChInf.ulRange = gAdRange;
  
  nRet = AdInputAD(hDeviceHandle3163, 1, gConfig.ulSingleDiff, &gSmplChInf, &wSmpData);
  if(nRet != AD_ERROR_SUCCESS){
    /* An error occurred */
    /* Please refer to online help in detail. */
    printf("AdInputAD error.\n");
    out = 0.0;
  } else {
    wSmpData = wSmpData & ((1 << gInfo.ulResolution) - 1);
    out = (double)(wSmpData - 0x7ff)/0x7ff;
  }
  return( gAdScale * out );
#else
  return(0.0);
#endif
}        /* ncsl_ad3163() */

/*
 * AD3163 initialize
 */
/*
 * input 1 sample
 */
void ncsl_ad3163open(FILE* fp){
#ifdef HARD_EXTENSION
  char strDeviceName[256],param[128];
  int nRet,flag=0;
  
  if(fp != NULL) {
	  fseek(fp, 0L, SEEK_SET);
	  while(!feof(fp)) {
		  if(fgets(param, 128, fp) == NULL)
			  break;
		  if (strstr(param, "[Ad3163") != NULL)
			  flag = 1;
	  }
	  if(!flag)
		  return;
	  printf("ncsl_da3305open completed.\n");
	  gAdRange = AD_5V;

  }
  else {
	gAdRange = AD_5V;
  }
  /* Open a device */
  strcpy(strDeviceName, "FBIAD1");
  hDeviceHandle3163 = AdOpen(strDeviceName);
  if(hDeviceHandle3163 == INVALID_HANDLE_VALUE) {
    printf("AdOpen error. %x\n",hDeviceHandle3163);
    return;
  }
  /* Read a device information */
  nRet = AdGetDeviceInfo(hDeviceHandle3163, &gInfo);
  if(nRet != AD_ERROR_SUCCESS){
    printf("AdGetDeviceInfo error.\n");
    return;
  }

  /* Read sampling request conditions */
  nRet = AdGetSamplingConfig(hDeviceHandle3163, &gConfig);
    if(nRet != AD_ERROR_SUCCESS){
    printf("AdGetSamplingConfig error.\n");
    return;
  }

  switch(gAdRange) {
  case  AD_5V:
    gAdScale = 5.0;
    break;
  case  AD_2P5V:
    gAdScale = 2.5;
    break;
  case  AD_1V:
    gAdScale = 1.0;
    break;

  }
#endif
}

/*
 * close device AD3163
 */
void ncsl_ad3163close(FILE* fp){
#ifdef HARD_EXTENSION
  char param[128];
  int flag=0;
  /*get parameter*/
  if(fp != NULL) {
	  fseek(fp, 0L, SEEK_SET);
	  while(!feof(fp)) {
		  if(fgets(param, 128, fp) == NULL)
			  break;
		  if (strstr(param, "[Ad3163") != NULL)
			  flag = 1;
	  }
	  if(!flag)
		  return;
  }

  if(AdClose(hDeviceHandle3163) != AD_ERROR_SUCCESS) {
    printf("AdClose error.\n");
    return;
  }
  printf("AdClose succesuuful.\n");
#endif
}

/*
 * open device DA3305
 */
void ncsl_da3305open(FILE* fp){
#ifdef HARD_EXTENSION
  char strDeviceName[256],param[128];
  int nRet,flag=0;

  /*get parameter*/
  if(fp != NULL) {
	  fseek(fp, 0L, SEEK_SET);
	  while(!feof(fp)) {
		  if(fgets(param, 128, fp) == NULL)
			  break;
		  if (strstr(param, "[Da3305") != NULL)
			  flag = 1;
	  }
	  if(!flag)
		  return;
	  printf("ncsl_da3305open completed.\n");
	  gDaRange = DA_5V;

  }
  else {
	gDaRange = DA_5V;
  }
  /* Open a device */
  strcpy(strDeviceName, "FBIDA1");
  hDeviceHandle3305 = DaOpen(strDeviceName);
  if(hDeviceHandle3305 == INVALID_HANDLE_VALUE) {
    printf("DaOpen error.\n");
    return;
  }
  /* Read a device information */
  nRet = DaGetDeviceInfo(hDeviceHandle3305, &gInfo3305);
  if(nRet != DA_ERROR_SUCCESS){
    printf("DaGetDeviceInfo error.\n");
    return;
  }
  
  /* Read sampling request conditions */
  nRet = DaGetSamplingConfig(hDeviceHandle3305, &gConfig3305);
  if(nRet != DA_ERROR_SUCCESS){
    printf("DaGetSamplingConfig error.\n");
    return;
  }
  
  switch(gDaRange) {
  case  DA_5V:
    gDaScale = 5.0;
    break;
  case  DA_2P5V:
    gDaScale = 2.5;
    break;
  case  DA_1V:
    gDaScale = 1.0;
    break;
  }
  gDaMode = DA_RANGE_BIPOLAR;
  /* Set mode */
  if(DaGetMode(hDeviceHandle3305, &gModeConfig) != DA_ERROR_SUCCESS) {
		printf("DaGetMode() error.\n");
		return;
  }
  /*1Channel*/
  gModeConfig.ModeChReq[0].ulRange = gDaMode;
  gModeConfig.ModeChReq[0].fVolt = gDaScale;
  if(DaSetMode(hDeviceHandle3305, &gModeConfig) != DA_ERROR_SUCCESS) {
		printf("DaSetMode() error.\n");
		return;
  }
#endif
}

/*
 * close device DA3305
 */
void ncsl_da3305close(FILE* fp){
#ifdef HARD_EXTENSION
  char param[128];
  int flag=0;
  /*get parameter*/
  if(fp != NULL) {
	  fseek(fp, 0L, SEEK_SET);
	  while(!feof(fp)) {
		  if(fgets(param, 128, fp) == NULL)
			  break;
		  if (strstr(param, "[Da3305") != NULL)
			  flag = 1;
	  }
	  if(!flag)
		  return;
	  /*printf("ncsl_da3305close completed.\n");*/
  }

  if(DaClose(hDeviceHandle3305) != DA_ERROR_SUCCESS) {
    printf("DaClose error.\n");
    return;
  }
  printf("DaClose succesuuful.\n");
#endif
}

/*
 * Output data to D/A channel
 */
void ncsl_da3305( int ch, double data )
{
#ifdef HARD_EXTENSION
  int    nRet;
  BYTE  bSmpData;
  WORD  wSmpData;
  DWORD  dwSmpData;
  double  out;
  WORD wMax,wMin,wMid;
  WORD pData[2];
  DASMPLCHREQ SmplChReq[2];

  /* Set data */
  wMax = 0xC00;  wMid = 0x800;  wMin = 0x400;
  //out = data / scale;
  if(data >= gDaScale)
    data = gDaScale;
  if(data < -gDaScale)
    data = -gDaScale;
  pData[0] = (WORD)((double)wMid*data/gDaScale+(double)wMid);


  SmplChReq[0].ulChNo = ch;
  SmplChReq[0].ulRange = gDaRange;
  nRet = DaOutputDA(hDeviceHandle3305, 1, &SmplChReq[0], &pData);
  if(nRet != DA_ERROR_SUCCESS){
    // An error occurred
    // Please refer to online help in detail.
    printf("DaOutputDa error.\n");
  }
#endif
}        /* ncsl_da3305() */


/*****************************************************************************
FUNCTION  NCSL_SIN
******************************************************************************
SIN FUNCTION
  
*****************************************************************************/

double 
ncsl_sin( double amp, double freq, double phase, double dummy1, double dummy2 )
{
  double  f;

  f = amp * sin(freq * 2 * 3.1415926 * NCS_TIME + phase);

  return( f );
}        /* ncsl_sin() */

/*****************************************************************************
FUNCTION  NCSL_SWEEP
******************************************************************************
SWEEP FUNCTION
  
*****************************************************************************/

double ncsl_sweep( double start, double amp, double ifreq, double efreq, 
                   double dummy1 ){
  double  freq,y;

  if( NCS_TIME < start ){
    return( 0.0 );
  }

  freq = ifreq + (efreq-ifreq)*(NCS_TIME-start)/ncsg_endtime;
  y = amp * sin(freq*2*3.1415926*(NCS_TIME-start));
  return( y );
}

/*****************************************************************************
 NCS DSPTEC EXTENTION

 FunctionGenerator
   mode = 0 -> Sin
   mode = 1 -> Square
   mode = 2 -> Ramp
*****************************************************************************/

DLLEXPORT double FunctionGenerator( double mode, double amp, 
                          double freq, double phase ){
  double f;
  f = amp * sin(freq * 2 * 3.1415926 * NCS_TIME + phase);
  if(mode == 1.0) {
    /* Square */
    if(f > 0.0)
      f = amp;
    else if(f < 0.0)
      f = -amp;
  }
  return( f );
}

double Delay( double lag, double in ){
  return in;
}

double TransFcn1(double in, double num1, double num2, 
                 double den1, double den2){
  return in;
}

double TransFcn2(double in, double num1, double num2, double num3,
                 double den1, double den2, double den3){
  return in;
}

DLLEXPORT double StepFunction(double init_out, double start_tm, double height,
                    double width, double period){
  double  d_val, tm_mod;

  if( NCS_TIME < (start_tm - MachineEps / 2.0) ) {
    return (init_out);
  }
  if(period != 0.0)  {
    d_val = (NCS_TIME - start_tm) / period;
    d_val = (double)(long)d_val;

    tm_mod = NCS_TIME - start_tm - d_val * period;
  } else {
    tm_mod = NCS_TIME - start_tm;
  }

  if( tm_mod < (width - MachineEps / 2.0) ){
    return (init_out + height);
  } else {
    return (init_out);
  }
}
/*****************************************************************************
FUNCTION  NCSF_RTCLK
******************************************************************************
READ REALTIME_CLOCK INFORMATION FILE

*****************************************************************************/
int 
ncsf_rtclk( char scfn[] )
{
  FILE *fp;
  char    rtclk_name[NCS_FNAME_WD];
  char    outobs[NCS_FNAME_WD];
  int    flag = 0;
  int    disp = 0;

  sprintf( rtclk_name, "%s.%s", scfn, "rtc" );
  if((fp = fopen(rtclk_name, "r")) != NULL) {
    fscanf(fp,"%d %d %s", &flag, &disp, outobs);
    g_realtime_mode = flag;
    fclose(fp);
  }
  else
    g_realtime_mode = 0;
  if(disp == 1)
    g_realtime_disp = 1;
  else
    g_realtime_disp = 0;

  g_realtime_outport = -1;
  return( NCS_SUCCESS );
  /* set OUT variable number for DA output */
  int    fd_out;
  char  out_name[NCS_FNAME_WD];
  int    r_size,cnt;
  long  offset;
  OutFile sc;

  sprintf( out_name, "%s.%s", scfn, SCF_OUT_EXTN );
  if ( (fd_out = open(out_name, O_RDONLY)) == FCNTL_ERROR ){
    exit(201);
  }
  cnt = 0;

  /* Head of RECORD3 -> RECORD2 -> RECORD3 96/10/15 */
  r_size = sizeof(OutFile);
  offset = OUT_RECORD3;
  _lseek(fd_out, offset, SEEK_SET);

  g_realtime_outport = -1;
  while (_read(fd_out, (char *) &sc, r_size) == r_size 
        && sc.type != SCF_EOF) {
    /* compare with variable name */
    if(strcmp(sc.out.rec3.buf_name, outobs) == NULL)
      g_realtime_outport = cnt;
    cnt++;
  }

  if( _close(fd_out) == FCNTL_ERROR ){
    exit(203);
  }
  /* fprintf(stdout,"realtime mode %d\n",g_realtime_mode); */
  /* _getch(); */

  return( NCS_SUCCESS );
}

/*****************************************************************************
FUNCTION  ncsf_hardopen
******************************************************************************/

int ncsf_hardopen(char scfn[])
{
  struct scf_xfp  scxfp;
  char  xfp_name[NCS_FNAME_WD];
  int     fd_xfp, r_size, ret;
  FILE* fp;

  if(g_realtime_mode < 2) {
	  sprintf(xfp_name, "%s.%s", scfn, SCF_XFP_EXTN);
	  if ( (fd_xfp = open(xfp_name, O_RDONLY)) == FCNTL_ERROR ){
		exit(201);
	  }

	  r_size = sizeof(struct scf_xfp);
	  ret = read(fd_xfp, (char *) &scxfp, r_size);
	  if(scxfp.type == '3') {
#ifdef WIN32
		/* external input device */
		ncsl_ad3163open(NULL);
		/* external output device */
		ncsl_da3305open(NULL);
#endif
		/* external H/W flag */
		gScxfpType = 3;
	  }
	  else
		gScxfpType = 0;

	  if(close(fd_xfp) == FCNTL_ERROR ){
		exit(203);
	  }
  }
  else {
	  /*sigma mode*/
	  sprintf(xfp_name, "%s.hrd", scfn);
	  if ((fp = fopen(xfp_name, "r")) == NULL/*FCNTL_ERROR*/ ){
		exit(201);
	  }
	  /* external input device */
	  ncsl_ad3163open(fp);
	  /* external output device */
	  ncsl_da3305open(fp);

	  fclose(fp);
  }
  return( NCS_SUCCESS );
}

int ncsf_hardclose(char scfn[])
{
  struct scf_xfp  scxfp;
  char  xfp_name[NCS_FNAME_WD];
  int     fd_xfp, r_size, ret;
  FILE* fp;

  if(g_realtime_mode < 2) {

	  sprintf(xfp_name, "%s.%s", scfn, SCF_XFP_EXTN);
	  if ( (fd_xfp = open(xfp_name, O_RDONLY)) == FCNTL_ERROR ){
		exit(201);
	  }

	  r_size = sizeof(struct scf_xfp);
	  ret = read(fd_xfp, (char *) &scxfp, r_size);
	  if(scxfp.type == '3') {
	#ifdef WIN32
		/* external input device */
		ncsl_ad3163close(NULL);
		/* external output device */
		ncsl_da3305close(NULL);
	#endif
	  }

	  if(close(fd_xfp) == FCNTL_ERROR ){
		exit(203);
	  }
  }
  else {
	  /*sigma mode*/
	  sprintf(xfp_name, "%s.hrd", scfn);
	  if ( (fp = fopen(xfp_name, "r")) == NULL/*FCNTL_ERROR*/) {
		exit(201);
	  }
	  /* external input device */
	  ncsl_ad3163close(fp);
	  /* external output device */
	  ncsl_da3305close(fp);

	  fclose(fp);
  }

  return( NCS_SUCCESS );
}

DLLEXPORT int realtime_calculate_init(char* moni_vflag, int* index,
							double report_end, int calc_end)
{
	/*char msg[_MAX_PATH];*/
	/*sprintf(msg, "%c %d %f",*moni_vflag, *index, report_end);*/
	/*printf("count -> %d\n",calc_end);*/
	/*printf("Stepsize -> %f\n",ncsg_calstep);*/
	return 1;
}

DLLEXPORT int realtime_calcucate_mode_check()
{
	//TODO
	return (g_realtime_mode % 2);
}

DLLEXPORT int realtime_calculate_mode1()
{
	return 1;
}

DLLEXPORT int realtime_calculate_mode2_init()
{
	char msg[_MAX_PATH];
	if(g_realtime_mode >= 2) {
		hStartEvent = OpenEvent(EVENT_ALL_ACCESS, TRUE, START_EVENT_NAME);
		if(hStartEvent == NULL) {
			sprintf(msg, "ERROR: OpenEvnt start error. %d", GetLastError());
			//fprintf(stdout,"%s\n",msg);
			printf("%s\n",msg);
		}

		hWaitEvent = OpenEvent(EVENT_ALL_ACCESS, TRUE, WAIT_EVENT_NAME);
		if(hWaitEvent == NULL) {
			sprintf(msg, "ERROR: OpenEvnt wait error. %d", GetLastError());
			//fprintf(stdout,"%s\n",msg);
			printf("%s\n",msg);
		}
		SetEvent(hWaitEvent);
	}
	g_calc_end_flag = 0;
	g_calc_cnt = 0;
	return 1;
}

DLLEXPORT int realtime_calculate_mode2_display(int calcnt, double time)
{
//printf("realtime_calculate_mode2_display\n");
  /* Communication */
  int    i,update,prmnum;
  double data;
  int   *dataptr,*prmptr;
  int    endfg;
  
  if(g_realtime_mode >= 2) {
    if(MapPointer != NULL) {
      /* data area */
      dataptr = (int *)MapPointer;
      /* check host control */
      endfg = *dataptr++;    /* check force exit */
      if(endfg)
        g_calc_end_flag = 1;
      /* data area */
	  if(g_calc_end_flag)
	    *dataptr++ = -1;
	  else
        *dataptr++ = 1;
      *dataptr++ = calcnt/*index*/;
      for( i = 0; i < ncsg_nstrd; i++ ){
        *((double*)dataptr) = *ncsg_strdptr[i];
        dataptr++;
      }
      /* parameter area */
      prmptr = (int*)MapPointer;
      prmptr += (g_moni_size+3);	/*g_moni_size:monitoring number*/
      prmnum = *prmptr++;
      for(i = 0; i <prmnum; i++) {
        update = *prmptr++;
        data = *((double*)prmptr);
        prmptr++;
        if(update) {
          scData[i].prm_val.prm_real = data;
          if (ncsf_prmset_func(&scData[i]) != NCS_SUCCESS) {
            //fprintf(stdout, "ncsf_prmset error.\n");
            printf("ncsf_prmset error.\n");
          }
          else
            //fprintf(stdout,"%d -> %f\n",i,data);
            printf("%d -> %f\n",i,data);
        }
      }
    }
  }
  return 1;
}

DLLEXPORT int realtime_calculate_mode2_next()
{
	if(g_realtime_mode >= 2) {
		SetEvent(hWaitEvent);
		g_calc_cnt++;
	}

	return 1;
}

/*get monitoring number*/
static int realtime_get_observable_info()
{
  char filename[_MAX_PATH], modelname[64];
  FILE* fp;
  OutFile src;
  int  n = 0;

  /*get model*/
  sprintf(filename, "%s/SCFN.NCS", get_tmpdir());
  if((fp = fopen(filename, "r")) == NULL) {
	  printf("SCFN open error. %s\n",filename);
	  return 512;
  }
  fscanf(fp, "%s", modelname);
  fclose(fp);
  /*get outfile*/
  sprintf(filename, "%s/%s.out", get_tmpdir(), modelname);
  fp = fopen(filename, "r+b");
  if(fp == NULL) {
	  printf("%s.obs open error. %s\n", modelname, filename);
	  return 512;
  }

  memset(&src, 0, sizeof(OutFile));
  
  while(fread(((void *)&src), sizeof(src), 1, fp)) {
    if( src.type == SCF_EOF ){
      break;
    }
	n++;
    printf( "%s\n", src.out.rec3.buf_name );
  }
  fclose(fp);
  return (n-2);		// substract dummy
}

DLLEXPORT int realtime_calculation_open_mapfile()
{
	/*printf("\n\ng_realtime_mode:%d\n",g_realtime_mode);*/
	char msg[_MAX_PATH];
	int obsnum,mapSize;
	if(g_realtime_mode >= 2) {
		//get observale
		obsnum = realtime_get_observable_info();
		g_moni_size = obsnum;
		mapSize = (obsnum + 3)*4 + MAP_SIZE;
/*printf("map_size:%d %d\n",mapSize,obsnum);*/

		hMapFile = OpenFileMapping(FILE_MAP_ALL_ACCESS, FALSE, MAPPING_NAME);
		if(hMapFile == NULL) {
			sprintf(msg, "ERROR: OpenFileMapping error. %d", GetLastError());
			printf("%s\n",msg);
		}

		MapPointer = MapViewOfFile(hMapFile,
								   FILE_MAP_ALL_ACCESS,0,0,mapSize/*MAP_SIZE*/);
		if(MapPointer == NULL) {
			sprintf(msg, "ERROR: MapViewOfFile error. %d", GetLastError());
			printf("%s\n",msg);
		}
	}
	return 1;
}

DLLEXPORT int realtime_calculation_close_mapfile()
{
	int		*flagptr;
	if(g_realtime_mode >= 2) {
		if(MapPointer) {
			/* set stop flag */
			flagptr = (int *)MapPointer;
			flagptr++;
			*flagptr = -1;

			UnmapViewOfFile(MapPointer);
			CloseHandle(hMapFile);
		}
	}
	return 1;
}
DLLEXPORT int realtime_calculate_mode2_wait()
{
	// syncronized
	if(g_calc_end_flag)
		return 1;	//finished

	if(g_realtime_mode == 2) {
		// wait for calculation
		WaitForSingleObject(hStartEvent, INFINITE);
		ResetEvent(hStartEvent);
	}
	return 0;
}

DLLEXPORT double ad3163( double ch )
{
	double data;
	double dummy2=0.0, dummy3=0.0, dummy4=0.0, dummy5=0.0;

	data = ncsl_ad3163( ch, dummy2, dummy3, dummy4, dummy5/*(int)ch*/ );
	//printf("\nad3163 input[%d] -> %f\n",(int)ch,data);
	return data;
}

DLLEXPORT double da3305( double ch, double data )
{
	double out=0.0;

	ncsl_da3305( (int)ch, data );
	//printf("\nda3305 output[%d] -> %f\n",(int)ch,data);
	return out;
}

#endif /* DSPTEC_EXTENSION */

#ifdef __cplusplus
}
#endif
