/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncssdl.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifdef HAVE_DLFCN_H
# include <dlfcn.h>
#endif

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libsatellite.h"
#include "libncsc.h"
#include "libncss.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef NCS_MODEL_DYNAMIC_LOADING

DLLEXPORT int ncsd_model_open()
{
  const char *tmpdir;
  char model[NCS_FNAME_WD], file[NCS_FNAME_WD], *p;
  tmpdir = get_tmpdir();
  SetWorkDirSCF(tmpdir);
  if(ModelNameSCFN(model) == NULL) return -1;
  snprintf(file, NCS_FNAME_WD, "%s/%s.dll", tmpdir, model);
  for(p=file; *p!='\0'; p++) if(*p == '/') *p='\\';
  /* load dynamic link library */
  ncsd_library = dlopen(file, RTLD_LAZY);
  if(ncsd_library == NULL) return -1;
  /* load some exported symbols */
  ncsd_network_func =
    (ncsd_network_func_t)dlsym(ncsd_library, "NETWORK");
  ncsd_constset_func =
    (ncsd_constset_func_t)dlsym(ncsd_library, "ncsf_constset");
  ncsd_initvalue_func =
    (ncsd_initvalue_func_t)dlsym(ncsd_library, "initvalue");
  ncsd_workset_func =
    (ncsd_workset_func_t)dlsym(ncsd_library, "ncsf_workset");
  ncsd_workcls_func =
    (ncsd_workcls_func_t)dlsym(ncsd_library, "ncsf_workcls");
  ncsd_getprmptr_func =
    (ncsd_getprmptr_func_t)dlsym(ncsd_library, "GetPrmPtr");

  /* do error check */
  if(ncsd_network_func   == NULL || ncsd_constset_func == NULL ||
     ncsd_initvalue_func == NULL || ncsd_workset_func  == NULL ||
     ncsd_workcls_func   == NULL || ncsd_getprmptr_func == NULL){
    /* several error occured */
    ncsd_model_close();
    return -1;
  }
  return 0;
}

DLLEXPORT int ncsd_model_close()
{
  if(ncsd_library == NULL) return -1;
  dlclose(ncsd_library);
  ncsd_library = NULL;
  ncsd_network_func = NULL;
  ncsd_constset_func = NULL;
  ncsd_initvalue_func = NULL;
  ncsd_workset_func = NULL;
  ncsd_workcls_func = NULL;
  ncsd_getprmptr_func = NULL;
  return 0;
}

#endif /* NCS_MODEL_DYNAMIC_LODING */

#ifdef __cplusplus
}
#endif
