/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncssdata.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#ifndef  _LIBNCSS_DATA_H_
#define  _LIBNCSS_DATA_H_

#ifdef EXTERN
# undef EXTERN
#endif
#ifdef MOD_NCS_LIBNCSS_GLOBAL_EXPORTS
# define EXTERN
#else
# define EXTERN extern
#endif

/* resource of NCS model file */

#ifdef __cplusplus
extern "C" {
#endif

/* mode & timer */
EXTERN char    ncsg_mode;
EXTERN double  ncsg_endtime; /* ncssbuff.c ncssrscf.c ncssdsp.c */
EXTERN double  ncsg_strstep; /* ncssfunc.c ncssrscf.c ncssdsp.c */
/* EXTERN long    ncsg_enditer; */ /* <none> */
/* EXTERN long    ncsg_striter; */ /* <none> */

EXTERN int     ncsg_vbuff[NCS_MONI_NVAR];    /* ncssfunc.c ncssrscf.c */
EXTERN int     ncsg_vbuffdim[NCS_MONI_NVAR]; /* ncssfunc.c ncssrscf.c */
EXTERN double  ncsg_bufstep;                 /* ncssfunc.c ncssrscf.c */

/* MachineEps : machine epsilon -  ncssintg.c ncsslib.c ncssdsp.c */
#ifdef MOD_NCS_LIBNCSS_GLOBAL_EXPORTS
double  MachineEps = 2.0e-16;
#else
EXTERN double  MachineEps;
#endif

#ifdef __cplusplus
}
#endif

#endif /* _LIBNCSS_DATA_H_ */
