/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncsmodel.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */

#ifndef  _NCS_MODEL_H_
#define  _NCS_MODEL_H_

#ifdef DLLEXPORT
# undef DLLEXPORT
#endif
#ifdef DLLIMPORT
# undef DLLIMPORT
#endif
#ifdef DECLSPEC
# undef DECLSPEC
#endif
#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#  define DLLIMPORT __declspec(dllimport)
# ifdef NCS_MODEL_SOURCE
#  define DECLSPEC DLLEXPORT
# else
#  define DECLSPEC DLLIMPORT
# endif
#else
# define DLLEXPORT
# define DLLIMPORT
# define DECLSPEC
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if (!defined(NCS_MODEL_SOURCE) && defined(NCS_MODEL_DYNAMIC_LOADING))
# define NETWORK(x,y,z)  ncsd_network_func((x),(y),(z))
# define ncsf_constset() ncsd_constset_func()
# define initvalue(x)    ncsd_initvalue_func(x)
# define ncsf_workset()  ncsd_workset_func()
# define ncsf_workcls()  ncsd_workcls_func()
# define GetPrmPtr(x,y)  ncsd_getprmptr_func((x),(y))
#else
DECLSPEC void    NETWORK( double NcsTime, double **Ncs_y, double **Ncs_dy );
DECLSPEC void    ncsf_constset();
DECLSPEC void    initvalue  ( double **Ncs_y );
DECLSPEC void    ncsf_workset();
DECLSPEC void    ncsf_workcls();
DECLSPEC double *GetPrmPtr( const char *mdl_name, const char *prm_name );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _NCS_MODEL_H_ */
