/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: libncss.h,v 1.5 2005/02/23 04:40:23 orrisroot Exp $ */
/*****************************************************************************

         Header file of Functions to Control of Pointer's List           
                   for NCS Module to SATELLITE                     

*****************************************************************************/

#ifndef _LIBNCSS_H_
#define _LIBNCSS_H_

#ifdef DLLEXPORT
# undef DLLEXPORT
#endif
#ifdef DLLIMPORT
# undef DLLIMPORT
#endif
#ifdef DECLSPEC
# undef DECLSPEC
#endif
#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#  define DLLIMPORT __declspec(dllimport)
# ifdef MOD_NCS_LIBNCSS_EXPORTS
#  define DECLSPEC DLLEXPORT
# else
#  define DECLSPEC DLLIMPORT
# endif
#else
# define DLLEXPORT
# define DLLIMPORT
# define DECLSPEC
#endif

#ifdef EXTERN
# undef EXTERN
#endif
#ifdef MOD_NCS_LIBNCSS_GLOBAL_EXPORTS
# define EXTERN
#else
# define EXTERN extern
#endif

#ifdef __cplusplus
extern "C" {
#endif

#undef exit

/* scf_mon.h */
struct moni_buff {
  int *num;
  int *dim;
};

/* lib/sim/plist.c */
#define  PL_ERROR_NODISP   0
#define  PL_ERROR_DISP     1
#define  PL_ERROR_ALLDISP  2

#define  PL_FATAL  (10)

struct PLIST {
  void         *member;
  struct PLIST *next;
};

typedef struct PLIST * PList;
typedef struct PLIST * PLPointer;
typedef void * PLMember;

DECLSPEC PList     plist_create(int arg);
DECLSPEC int       plist_destroy(PList lst);
DECLSPEC PLPointer plist_advance(PList current, PLPointer pointer);
DECLSPEC PLPointer plist_retreat(PList current, PLPointer pointer);
DECLSPEC PLMember  plist_read_data(PList current, PLPointer pointer);
DECLSPEC PLPointer plist_write_data(PList current, PLPointer pointer, 
                                    PLMember data);
DECLSPEC PLPointer plist_insert(PList current, PLPointer pointer, 
                                PLMember data);
DECLSPEC PLPointer plist_delete(PList current, PLPointer pointer);
DECLSPEC int       plist_number_cell(PList current);
DECLSPEC PLPointer plist_go_top(PList current);
DECLSPEC PLPointer plist_go_end(PList current);
DECLSPEC PLPointer plist_go_nth(PList current, int n);

/* lib/sim/ncssutil.c */
DECLSPEC void     init_queue(double *q, long qsize, double init);
DECLSPEC double   delay( double *q, long *ptr, long qsize, double in );
DECLSPEC char   **alloc2d(int x, int y, int size);
DECLSPEC void     free2d( char **f, int m);

/* lib/sim/strfunc.c */
DECLSPEC int  string_ana( char buffer[], char *anatbl[], int mode );

/* lib/sim/ncsssate.c */
DECLSPEC int  ncsf_scfread();
DECLSPEC void ncsf_memalloc(int nbuff, int dpoint );
DECLSPEC void ncsf_strd(int nstrd, int mem_index, double **dptr);
DECLSPEC void ncsf_StoreData(int dpoint, int nstrd);
#ifdef DSPTEC_EXTENSION
DECLSPEC int  ncsf_scfclose();
#endif

/* lib/sim/ncssbuff.c */
typedef struct exbuff {
  int     ncsg_inp_buffnum;
  char   *ncsg_datfile;
  int     ic;
  double *ybuf;
  int     iypt;
  int     timeid;
  char   *timefile;
  double *tbuf;
  int     itpt;
} Exbuff;

DECLSPEC double    ncsl_interp(double pos, double buf_dim, 
                               double dummy0, double dummy1, double dummy2);
DECLSPEC PLPointer add_exbuf_info(PList buffinfo, PLPointer buffinfo_p, 
                                  int buffnum, char *datafile, int timeid,
                                  char *timefile);
DECLSPEC void      remove_all_exbuf_info(PList buffinfo);

/* lib/sim/ncssrscf.c */
#define NCS_XFP_MAX       5

typedef struct xin_info { /* EXTERNAL INPUT INFORMATION TABLE */
  double *comp_addr;
  int    comp_number;
  int    xfd_number;
} xininfo_t ;

typedef struct xfp_info { /* EXTERNAL INPUT FUNCTION PARAMETER TABLE */
  int     xf_number;
  double  xf_para[NCS_XFP_MAX];
} xfpinfo_t ;

DECLSPEC int  ncsf_rdmat( char scfn[] );
DECLSPEC int  ncsf_rdprm( char *scfn );
DECLSPEC int  ncsf_rdxinfo( char *scfn );
DECLSPEC int  ncsf_rdout( char scfn[] );
DECLSPEC int  ncsf_rddly( char scfn[] );
DECLSPEC void ncsf_FreeOutBuffer();

/* lib/sim/ncssfunc.c */
#define NCS_MONI_VLONLY  '1'

typedef double (*XIN_FUNC)(double,double,double,double,double);

DECLSPEC void ncsf_scset(int *dpoint, int *calc_end, int *str_period,
                         double *report_end);
DECLSPEC void ncsf_initset();
DECLSPEC void ncsf_moniset(char *moni_vflag);
DECLSPEC void ncsf_startsign();
DECLSPEC void ncsf_repostart();
DECLSPEC void ncsf_dataout(char *moni_vflag, int index, int strd_cnt);
DECLSPEC void ncsf_repoprogress(int calc_cnt, double report_end);
DECLSPEC void ncsf_endsign();
DECLSPEC void ncsf_repoend();
DECLSPEC void ncsf_xinset(int nxinc, xininfo_t *xin_data, xfpinfo_t *xfp_data, 
                          XIN_FUNC xin_func[]);
DECLSPEC void ncsf_update(int nt, int nctbl[], double *out_ptr[], 
                          double *tmp_ptr[]);
#ifdef DSPTEC_EXTENSION
DECLSPEC void ncsf_xinset_init(int nxinc, xininfo_t *xin_data,
                               xfpinfo_t *xfp_data);
#endif


/* lib/sim/ncsinteg.c */
typedef void (*INTEG_FUNC)(double,double**,double**);
DECLSPEC void AdapIntgrl(INTEG_FUNC cf, double tstart, double tstep, int cell,
                         int neqn,double **y, double *relerr, int *iflag);
DECLSPEC void EulerIntgrl(INTEG_FUNC cf, double t, double h, int cell, 
                          int neqn, double **y, double *relerr, int *iflag);
DECLSPEC void RKG4Intgrl(INTEG_FUNC cf, double t, double h, int cell, 
                         int neqn, double **y, double *relerr, int *iflag);


/* lib/sim/ncsslib.c */
#define NCS_NORMAL      (0)
DECLSPEC double ncsl_rcab(double c1, double c2, double c3, double c4,
                          double c5, double c6, double c7, double V);
DECLSPEC double ncsl_thold(double input, double theta);
DECLSPEC double ncsl_sigmoid(double a);
DECLSPEC double ncsl_pulse(double start_tm, double init_out, 
                           double height, double width, double period);
DECLSPEC double ncsl_ramp(double rampup_tm, double init_out, 
                          double gradient, double dummy1, double dummy2);
DECLSPEC double ncsl_differ(double init, double y, double y_old);
DECLSPEC double ncsl_intgrl(double init, double y, double f_old);

/* for lib/main/ncssmain.c and lib/npe/ncssnpe.c */
#define OUTPUT_INIT         'I'
#define DELAY_INIT_SET      'S'
#define CALCULATE           'C'
#define DELAY_INIT_AUTO_SET 'A'
#define DELAY_INIT_FIXD_SET 'F'

/* lib/sim/ncssdsp.c */
#ifdef DSPTEC_EXTENSION
DECLSPEC double FunctionGenerator( double mode, double amp, 
                                   double freq, double phase );
DECLSPEC double StepFunction(double init_out, double start_tm, double height,
                             double width, double period);
DECLSPEC double da3305(double ch, double data);
DECLSPEC double ad3163(double ch);
DECLSPEC int realtime_calculate_init(char* moni_vflag, int* index,
                                     double report_end, int calc_end);
DECLSPEC int realtime_calcucate_mode_check();
DECLSPEC int realtime_calculate_mode1();
DECLSPEC int realtime_calculate_mode2_init();
DECLSPEC int realtime_calculate_mode2_display(int calcnt, double time);
DECLSPEC int realtime_calculate_mode2_next();
DECLSPEC int realtime_calculation_open_mapfile();
DECLSPEC int realtime_calculation_close_mapfile();
DECLSPEC int realtime_calculate_mode2_wait();
#endif

/* lib/sim/ncssdata.c */
/* global variables */
/* SYSTEM DEFINED GLOBAL VARIABLES */
#define NCS_XF_MAX 10
#define NAME_SIZE  32             /* LENGTH OF NAME + EOS */
#define TIME       NcsTime

EXTERN DECLSPEC double     NCS_TIME; /* ncsm ncsn */
EXTERN DECLSPEC int        CN;       /* model */
EXTERN DECLSPEC int        PRECN;
EXTERN DECLSPEC int        POSCN;
EXTERN DECLSPEC double     POSOUT;
EXTERN DECLSPEC double     INPUT;
EXTERN DECLSPEC double     *NET;
/* mode & timer */
/* EXTERN DECLSPEC char       ncsg_mode;    /\* <none> *\/  */
/* EXTERN DECLSPEC double     ncsg_endtime; /\*  *\/ */
EXTERN DECLSPEC double     ncsg_calstep; /* ncsm */
/* EXTERN DECLSPEC double     ncsg_strstep; /\*  *\/ */
/* EXTERN DECLSPEC long       ncsg_enditer; /\* <none> *\/ */
/* EXTERN DECLSPEC long       ncsg_striter; /\* <none> *\/ */
/* module information table */
EXTERN DECLSPEC int        ncsg_ntout;   /* model ncsm ncsn */
EXTERN DECLSPEC int        ncsg_ntxin;   /* model */
EXTERN DECLSPEC int        ncsg_ntobs;   /* model */
EXTERN DECLSPEC int       *ncsg_ncout;   /* [model] ncsm ncsn */
EXTERN DECLSPEC int       *ncsg_ncxin;   /* [model] ncsm ncsn */
EXTERN DECLSPEC int       *ncsg_ncobs;   /* [model] ncsm ncsn */
/* memory address table */
EXTERN DECLSPEC double   **ncsm_outptr;  /* model ncsm ncsn */
EXTERN DECLSPEC double   **ncsm_xinptr;  /* model */
EXTERN DECLSPEC double   **ncsm_obsptr;  /* model */
EXTERN DECLSPEC double   **ncsm_subptr;  /* model ncsm ncsn */
/* module name table & address table */
EXTERN DECLSPEC char     **ncsg_outtbl;    /* model */
EXTERN DECLSPEC char     **ncsg_xintbl;    /* model */
EXTERN DECLSPEC char     **ncsg_obstbl;    /* model */
EXTERN DECLSPEC char     **ncsg_outtblptr; /* model */
EXTERN DECLSPEC char     **ncsg_xintblptr; /* model */
EXTERN DECLSPEC char     **ncsg_obstblptr; /* model */
/* EXTERNAL INPUT INFORMATION */
EXTERN DECLSPEC int        ncsg_nxinc;    /* ncsm ncsn */
EXTERN DECLSPEC xininfo_t *ncsg_xindata;  /* model ncsm ncsn */
EXTERN DECLSPEC xfpinfo_t *ncsg_xfpdata;  /* model ncsm ncsn */
EXTERN DECLSPEC XIN_FUNC  *ncsg_xinfaddr; /* model ncsm ncsn */
/* NCS LIBRARY */
#define ramp(x1,x2,x3) ncsl_ramp(x1,x2,x3,ncsg_dummy1,ncsg_dummy2) /* <?> */
EXTERN DECLSPEC double     ncsg_dummy1; /* <?> */
EXTERN DECLSPEC double     ncsg_dummy2; /* <?> */
/* STORING DATA */
EXTERN DECLSPEC int        ncsg_nstrd;                   /* ncsm ncsn */
EXTERN DECLSPEC char       ncsg_strflg;                  /* <write>   */
EXTERN DECLSPEC char       ncsg_strfile[NCS_DATA_FNAME]; /* <write>   */
EXTERN DECLSPEC double   **ncsg_strdptr;                 /* ncsn */
EXTERN DECLSPEC int       *ncsg_out_buffnum;             /*  */
EXTERN DECLSPEC int       *ncsg_out_buffdim;             /*  */
EXTERN DECLSPEC char     **ncsg_out_bufname;             /*  */
/* GRAPH MONITER */
EXTERN DECLSPEC char       ncsg_monimode;                /*  */
EXTERN DECLSPEC int        ncsg_ngmoni;                  /* <none>  */
EXTERN DECLSPEC int        ncsg_nvmoni;                  /* <write> */
EXTERN DECLSPEC double    *ncsg_gmoniptr[NCS_MONI_NVAR]; /* <none>  */
EXTERN DECLSPEC double    *ncsg_vmoniptr[NCS_MONI_NVAR]; /*  */
/* For Adaptive Integlation */
/* ncsg_cell         - Number of Cell       */
/* ncsg_neqn         - Number of equation   */
/* ncsg_relerr       - Relative Error       */
/* ncsg_integ_method - Integration Method   */
EXTERN DECLSPEC int        ncsg_cell;        /* model ncsm ncsn */
EXTERN DECLSPEC int        ncsg_neqn;        /* model ncsm ncsn */
EXTERN DECLSPEC double     ncsg_relerr;      /* model ncsm ncsn */
EXTERN DECLSPEC char       ncsg_intg_method; /* ncsm ncsn */
/* For Buffer input */
EXTERN DECLSPEC int       ncsg_cdpoint;     /* ncsn */
EXTERN DECLSPEC PList     ncsg_buff_info;   /* ncsm ncsn */
EXTERN DECLSPEC PLPointer ncsg_buff_info_p; /* ncsm ncsn */
EXTERN DECLSPEC int       exbuff_num;       /* ncsm ncsn */
/* For Delay */
EXTERN DECLSPEC double   *ncsg_dlytime;      /* [model] */
EXTERN DECLSPEC double   *ncsg_dlyinit;      /* model */
EXTERN DECLSPEC int      *ncsg_qsize;        /* model */
EXTERN DECLSPEC char     *ncsg_dlyinit_flg;  /* model */
EXTERN DECLSPEC char      ncsg_delay_flag;   /* model ncsm ncsn */
/* Other vars */
EXTERN DECLSPEC long      ncsg_bufperiod;    /* ncsn */
EXTERN DECLSPEC double  **ncs_yp;            /* ncsm */
EXTERN DECLSPEC double  **ncs_y;             /* ncsm */
EXTERN DECLSPEC double  **ncs_buffer;        /* ncsn */
/* function of model wrapper */
typedef int (*ncsf_prmset_func_t)(struct scf_prm*);
EXTERN DECLSPEC ncsf_prmset_func_t ncsf_prmset_func;

/* ncssdl.c */
#ifdef NCS_MODEL_DYNAMIC_LOADING
typedef void (*ncsd_network_func_t)(double, double**, double**);
typedef void (*ncsd_constset_func_t)();
typedef void (*ncsd_initvalue_func_t)(double**);
typedef void (*ncsd_workset_func_t)();
typedef void (*ncsd_workcls_func_t)();
typedef double* (*ncsd_getprmptr_func_t)(char *,char*);
EXTERN DECLSPEC void                  *ncsd_library;
EXTERN DECLSPEC ncsd_network_func_t    ncsd_network_func;
EXTERN DECLSPEC ncsd_constset_func_t   ncsd_constset_func;
EXTERN DECLSPEC ncsd_initvalue_func_t  ncsd_initvalue_func;
EXTERN DECLSPEC ncsd_workset_func_t    ncsd_workset_func;
EXTERN DECLSPEC ncsd_workset_func_t    ncsd_workcls_func;
EXTERN DECLSPEC ncsd_getprmptr_func_t  ncsd_getprmptr_func;
DECLSPEC int ncsd_model_open();
DECLSPEC int ncsd_model_close();
#endif

#endif /* _LIBNCSS_H_ */

#ifdef __cplusplus
}
#endif
