#
# hhmodelE.sl
#
series V[3];

nassign("hhmodelE");                 # Registration of model file
npp();                               # Run the priprosessor
nlink("-O2");                        # Making executive file

ntime(10,0.001,0.01,1);              # Set to time condition
nstim("HH",0,"P",1,0,100,3,999);       # Set to input conditon
nout(V,0,"HH",0,1);
nout(V,1,"HH",5,1);
nout(V,2,"HH",8,1);
ninteg("R");                           # Change to integration
ncal();

#graph
wopen(1,"A4",0,0);
origin(20,40);
color("red","black");
time=(0~1000)/100;
graph(V[0],time,0,0,0,0,0);
scale("N","D","N","D");
graph(V[1],time,0,0,0,0,0);
scale("N","D","N","D");
graph(V[2],time,0,0,0,0,0);
title(1,"time [ms]","membrane potential [mV]");
axis(1,1,"XY","XY",6,0,0,0,0,0);
frame();

