/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: setup.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*******************************************************************
 *
 *		NCS module
 *		ncs.cpp
 *
 *******************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef WIN32
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <process.h>
#include <direct.h>
#include <io.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "ncs.h"

extern int do_ncspp_cmd();

/* dll interface */
#ifdef __cplusplus
extern "C" {
#endif

/* BCC path */
/* #ifdef WIN32 */
/* char  bcc_path[_MAX_PATH]; */
/* static int CreateBCCLibrary(); */
/* #endif */

DLLEXPORT const char *SetupCommand(){
  static char *setup_command="setup";
  return setup_command;
}

DLLEXPORT const char *CleanCommand(){
  static char *clean_command="clean";
  return clean_command;
}

/* when module is loaded */
int DLLEXPORT setup()
{
  const char *tmpdir;
  tmpdir = get_tmpdir();
  if(SetWorkDirSCF(tmpdir) == NCS_FALSE)
    return 1;
  return 0;
/* #ifdef WIN32 */
/*   /\* check compiler *\/ */
/*   int compfg; */
/*   DWORD dwSize,dwType = REG_SZ; */
/*   char buf[_MAX_PATH]; */
  
/*   compfg = GetCompiler(); */
/*   if(compfg == BORLAND) { */
/*     char pathbuffer[_MAX_PATH]; */
/*     char searchfile[] = "BCC32.EXE"; */
/*     char envvar[] = "PATH"; */
/*     char *cptr; */

/*     _searchenv( searchfile, envvar, pathbuffer ); */
/*     if( *pathbuffer == '\0' ) { */
/*       printf("Not installed Borland C++ Compiler.\n"); */
/*       return 1; */
/*     } */
/*     cptr =strstr(pathbuffer, searchfile); */
/*     *cptr = '\0'; */
/*     pathbuffer[strlen(pathbuffer)-1] = '\0'; */
/*     strcpy(bcc_path, pathbuffer); */
    
/*     /\* create import library *\/ */
/*     if(!CreateBCCLibrary()) { */
/*       printf("Failed to create Borland C++ import library.\n"); */
/*       return 1; */
/*     } */
/*   } */
/* #endif */
}

/* when module is exited */
int DLLEXPORT clean()
{
  CleanWorkDirSCF();
  return 0;
}

/* #ifdef WIN32 */
/* /\* create BCC import library *\/ */
/* static int CreateBCCLibrary() */
/* { */
/*   char moduledir[_MAX_PATH]; */
/*   char curdir[_MAX_PATH]; */
/*   HWND hWnd; */
/*   STARTUPINFO si; */
/*   PROCESS_INFORMATION pi; */
/*   FILE *fp; */
  
/*   _getcwd(curdir,_MAX_PATH); */
/*   if(!GetModuleDirectory(moduledir, _MAX_PATH)) */
/*    return 0; */
/*   strcat(moduledir, "\\..\\"); */
/*   _chdir(get_tmpdir()); */
/*   if((fp = fopen("bcc.bat","w")) == NULL) */
/*     return 0; */
/*   fprintf(fp,"implib -a libsatellite_bcc.lib \"%s\\libsatellite.dll\"\n", */
/*           moduledir); */
/*   fprintf(fp,"implib -a libncsc_bcc.lib \"%s\\libncsc.dll\"\n", */
/*           moduledir); */
/*   fprintf(fp,"implib -a libncsm_bcc.lib \"%s\\libncsm.dll\"\n", */
/*           moduledir); */
/*   fprintf(fp,"implib -a ncsdat_bcc.lib \"%s\\ncsdat.dll\"\n", */
/*           moduledir); */
/*   fprintf(fp,"implib -a libncsn_bcc.lib \"%s\\libncsn.dll\"\n", */
/*           moduledir); */
/*   fclose(fp); */
  
/*   ZeroMemory(&si,sizeof(STARTUPINFO)); */
/*   si.cb = sizeof(STARTUPINFO); */
/*   si.dwFlags = STARTF_USESHOWWINDOW; */
/*   si.wShowWindow = SW_SHOWNORMAL; */
/*   si.wShowWindow = SW_MINIMIZE; */
/*   if((hWnd = FindWindow(NULL, PACKAGE_STRING)) == NULL) { */
/*     /\* MSDOS *\/ */
/*     if(CreateProcess(NULL, "cmd.exe /c bcc.bat", */
/*                      NULL,NULL,FALSE,CREATE_NEW_CONSOLE, */
/*                      NULL,NULL,&si,&pi)){ */
/*         WaitForSingleObject( pi.hProcess,INFINITE ); */
/*     } */
/*     else { */
/*       _chdir(curdir); */
/*       return (0); */
/*     } */
/*   } */
/*   else { */
/*     /\* WINDOW *\/ */
/*     if(CreateProcess(NULL, "cmd.exe /c bcc.bat", */
/*                      NULL,NULL,FALSE,0, */
/*                      NULL,NULL,&si,&pi)){ */
/*      WaitForSingleObject( pi.hProcess,INFINITE ); */
/*     }else{ */
/*       _chdir(curdir); */
/*       return (0); */
/*     } */
/*   } */
/*   _chdir(curdir); */
/*   return 1; */
/* } */

/* #endif */

#ifdef __cplusplus
}
#endif


