/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: screen.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*****************************************************************************

             Functions to Dispaly Screen 

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "ncs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define PAGER(x) syscom->console->run_pager(x)

/*
 *	Display parameter
 */
int screen_out( char *filename, int row ){
  int code,ret;
  ret = 0;
  code = PAGER(filename);
  switch(code){
  case  0: ret = 0;   break; /* normal exit */
  case -1: ret = 201; break; /* can't open working file */
  case -2: ret = 437; break; /* can't create child process */
  case -3: ret = 450; break; /* process not found */
  case -4: ret = 451; break; /* interupt */
  case -5: ret = 452; break; /* process is stopping */
  case -6: ret = 453; break; /* core dumped */
  default: ret = 454; break; /* unknown error of process termination. */
  }
  return ret;
}

#ifdef __cplusplus
}
#endif
