/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: npp.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*****************************************************************************
  
                          EXECUTE NCS PREPROCESSOR
  
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifndef WIN32
#include <unistd.h>
#endif

#include "SL_cmd.h"

#include "libncsc.h"
#include "ncs.h"

#define BUFSIZE    512
#define CONSOLE(x) syscom->console->x

#ifdef __cplusplus
extern "C" {
#endif

int do_ncspp_cmd(const char *model, const char *header){
  int   pid,code;
  char  mod_dir[BUFSIZE], lib_path[BUFSIZE], bin[BUFSIZE];
  const char *ncs_tmpdir;

  if(model == NULL)  model = "";
  if(header == NULL) header = "";

  GetModuleDirectory(mod_dir, BUFSIZE);
#ifdef WIN32
  /* TODO : replace to libsatellite::GetBinDirectory() */
  snprintf(lib_path,BUFSIZE,"%s/..",mod_dir);
  snprintf(bin, BUFSIZE,"\"%s/ncs/ncspp.exe\"",mod_dir);
#else
  int i;
  char *tmp;
  snprintf(lib_path,BUFSIZE,"%s/ncs",mod_dir);
  tmp = strstr(mod_dir, "/lib/");
  if(tmp != NULL){
    size_t len;
    len = strlen(tmp);
    if(len + 4 >= BUFSIZE) return 436;
    for(i=0;i<len+1;i++)
      tmp[len+4-i] = tmp[len-i];
    tmp[0]='/';tmp[1]='l';tmp[2]='i';tmp[3]='b';
    tmp[4]='e';tmp[5]='x';tmp[6]='e';tmp[7]='c';tmp[8]='/';
  }
  snprintf(bin,BUFSIZE,"%s/ncs/ncspp",mod_dir);
#endif

  if(*model != '\0'){
    strcat(bin, " ");
    strcat(bin, model);
    if(*header != '\0'){
      strcat(bin, " ");
      strcat(bin, header);
    }
  }

  /* set ncs temp directory */
  ncs_tmpdir = get_tmpdir();
#ifdef HAVE_SETENV
  setenv(NCS_TEMPDIR_ENV, ncs_tmpdir, 1);
#else
 {
   static char env[_MAX_PATH];
   if(strlen(ncs_tmpdir) + strlen(NCS_TEMPDIR_ENV) + 2 > _MAX_PATH)
     return -1;
   sprintf(env, "%s=%s", NCS_TEMPDIR_ENV, ncs_tmpdir); /* safe */
   putenv(env);
 }
#endif

  pid = create_child_process(bin, CONSOLE(ifd), CONSOLE(ofd), CONSOLE(efd),
                             lib_path);
  if(pid == -1){
    code = 436; /* fail to run */
  }else{
    int status;
    status =wait_child_process(pid, &code);
    if(status ==-1){
      code = 450; /* process not found */
    }else if(status == 0){ /* normal exit */
      switch(code){
      case 0: /* normal exit */ break;
      case 100: code =  7;  break;
      case 101: code = 21;  break;
      case 102: code = 22;  break;
      case 103: code =  3;  break;
      case 104: code =  5;  break;
      case 105: code = 60;  break;
      case 106: code = 61;  break;
      case 107: code = 70;  break;
      case 108: code = 75;  break;
      case 109: code = 80;  break;
      case 110: code = 81;  break;
      case 111: code = 50;  break;
      case 112: code = 55;  break;
      case 113: code = 204; break;
      default:  code = 454; break;
      }
    }else if(status == 1){
      code = 451; /* signal caught */
    }else if(status == 2){
      code = 452; /* process is stoping */
    }else if(status == 3){
      code = 453; /* core dumped */
    }else{ 
      code = 454; /* unknown error */
    }
  }
  return code;
}


DLLEXPORT int mod_ncs_npp(){
  int ret;
  const char *model, *header;
  model = GetString(0);
  header = GetString(1);
  ret = do_ncspp_cmd(model, header);
  return ret;
}

#ifdef __cplusplus
}
#endif
