/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ninteg.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************
  
             	   NCS SIMULATION CONDITION SETTING COMMAND 
                      SETTING OF INTEGRATON INFORMATION 

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "nlist.h"

#ifdef __cplusplus
extern "C" {
#endif

int DLLEXPORT mod_ncs_ninteg(){
  char   *integ_type;
  int     maxcell;
  int	  narg;
  double  relerr;
  MatFile sc;
  char    tmpfile[NCS_FNAME_WD];
  int row;
  
  narg = GetArgNum()/*syscom.narg*/;

  if( MatGetInfoSCF( &sc, 0 ) == NCS_FALSE ){
    return(62);
  }

  integ_type = GetString(0);
  maxcell    = (int) GetScalar(1);
  relerr     = GetScalar(2);

  switch( *integ_type ){
  case 'l':
  case 'L':
    strcpy( tmpfile, get_tmpdir() );
    strcat( tmpfile, "/" );
    strcat( tmpfile, TMPNLIST );
    row = MatIntegListupSCF( tmpfile/*fp_tmp*/ );
    if( row > 0 ){
      screen_out( tmpfile, row );
	}
    break;
  case 'E':
  case 'F':
  case 'R':
    switch( narg ){
    case 3:
      sc.integral.relerr = relerr;
    case 2:
      sc.integral.maxcell = maxcell;
    case 1:
      sc.integral.method = *integ_type;
      break;
    }

    if( MatWriteInfoSCF( &sc ) == NCS_FALSE ){
      return(61);
    }
    
    break;
  default:
    printf("NINTEG ... FAILED!!\n");
    break;
  }
  return(0);
}

#ifdef __cplusplus
}
#endif
