/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nerase.cpp,v 1.3 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************

                  NCS SIMULATION CONDITION ERASE COMMAND
                         ERASING OF EXTERNAL INPUTS

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************

        NERASE main function


*****************************************************************************/

DLLEXPORT int mod_ncs_nerase(){
  OutFile osc;
  XinFile isc;
  int 	number = 0;
  char	*type, *all;
  int 	buff_dim;
  char 	*name = NULL;
  int   flag, narg;
  
  type = GetString(0);
  all = GetString(1);
  if(!all)
    return(100);
  if(strcmp(all,"ALL") == 0){
    flag = SCF_ALL_MATCH;
  }else{
    flag = NCS_FALSE;
    number = (int)GetScalar(1);
    name = all;
  }

  narg = GetArgNum();
  
  switch( *type ){
  case 'S':
    if( narg > 2 ){
      number = (int)GetScalar(2); 
    } else {
      name = NULL;
    }
    XinSetInfoSCF( &isc, name, number );
    if( XfpRemoveInfoSCF( &isc, flag ) == NCS_FALSE ){
      return(73);
    };
    break;
    
  case 'O':
    if( narg > 2 ){
      buff_dim = (int)GetScalar(2);
    }else{
      buff_dim = SCF_ALL_MATCH;
    }
    
    OutSetInfoSCF( &osc, number, name, buff_dim, NULL, 0, 0, NULL );
    if( OutRemoveInfoSCF( &osc, flag ) == NCS_FALSE ){
      return(53);
    }
    break;
    
  default:
    return(100);
    break;
  }
  return( 0 );
}

#ifdef __cplusplus
}
#endif

