/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ndelay.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************
  
	             NCS SIMULATION CONDITION SETTING COMMAND
                         SETTING OF DELAY INFORMATION 

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

#ifdef __cplusplus
extern "C" {
#endif

 DLLEXPORT int mod_ncs_ndelay(){
   DlyFile dly;
   char	*mdl_name, *inp_name, *str, flag;
   double	dly_time, initvalue;

   mdl_name = GetString(0);
   inp_name = GetString(1);
   dly_time = GetScalar(2);
   initvalue = GetScalar(3);
   str = GetString(3);
   
   if( dly_time < 0 ){
     printf( "Delay time = %f\n", dly_time );
     return (212);
   }
   
   if(str != NULL) {
     if( strcmp(str, "AUTO") == 0 || strcmp(str, "auto") == 0 ){
       flag = SCF_DLY_FLAG_AUTO;
     } else {
       flag = SCF_DLY_FLAG_FIX;
     }
   }

   DlySetInfoSCF( &dly, mdl_name, inp_name, dly_time, 0, &flag );

   if( DlyWriteInfoSCF( &dly ) == NCS_FALSE ){
     printf( "Module name = %s : variable name = %s\n", 
             mdl_name, inp_name );
     return 71;
   };

   return( 0 );
}

#ifdef __cplusplus
}
#endif
