/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: sum.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*****************************************************
*    Integration                                     *
*****************************************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_sum(){
  register int    i;
  Buffer         *data = NULL, *need_integ = NULL, *integ = NULL, sum;
  int             dim1, index1[MAX_INDEX];
  int             dim2, index2[MAX_INDEX];
  int             n, id;

  /***** Load System Parameter *****/

  /* Get Arguments from SATELLITE LANGUAGE */
  data       = GetSeries(0, &dim1, index1);
  need_integ = GetSeries(1, &dim2, index2);
  id         = GetBufferID(1);

  if (data == NULL)
    return (4);
  n = IndexSize(dim1, index1);

  if (need_integ != NULL) {
    FreeBuffer(need_integ);
    if ((integ = (Buffer *) CAllocBuffer(n)) == NULL) return (8);
  }
  /***** Calculation ( sum ) *****/
  sum = 0.0;
  if (need_integ != NULL) {
    for (i = 0; i < n; i++) {
      sum += data[i];
      integ[i] = sum;
    }
    if ( WriteBuffer(id, dim1, index1, integ) <= 0 ) return (3);
  } else {
    for (i = 0; i < n; i++)
      sum += data[i];
  }

  ReturnScalar(sum);
  return 0;
}

#ifdef __cplusplus
}
#endif
