/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: spline.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*
 * yip = spline(xin, yin, xip | dpt [, xip])
 *
 * xin, xip ϡx[0] < x[1] < ... < x[n-1] Ǥɬפ롥
 * 
 */
#ifdef __cplusplus
extern "C" {
#endif

static int natural_spline_derivatives (double *xx, double *yy,
				       int n, double *yy2 );
static int spline (double *xa, double *ya, int n,
		   double *x,  double *y,  int m );

int ispp_interp_spline(){
  int      args    = 0;
  int      dimx, idxx[MAX_INDEX];
  int      dimy, idxy[MAX_INDEX];
  int      dimo, idxo[MAX_INDEX]; 
  int      outx_id = 0;
  int      i, n, fmode = 0, imode = 0;
  int      dpt = 0;
  Buffer  *xa, *ya, DI;
  Buffer  *xo = NULL, *yo = NULL;

  args = GetArgNum();
  if (( xa = GetSeries(1, &dimx, idxx )) == NULL ) return (4);
  if (( ya = GetSeries(2, &dimy, idxy )) == NULL ) return (4);
  if ( dimx != 1 ) return (24); /* ޤΤȤ1Τߥݡ */
  if ( dimx != dimy || idxx[0] != idxy[0] ) return (16);

  n = idxx[0];
  for ( i = 0; i < n-1; i++ )
    if ( xa[i] >= xa[i+1] ) return (26); /* xa[i] < xa[i+1] ǤʤХ */


  if ( strcmp(GetArgType(3),"series") == 0 ) {
    /* 4 series ξϡо x ηˤ */
    if ((xo  = GetSeries(3, &dimo, idxo )) == NULL ) return  (17);
    if ( dimo != 1  ) return (24);
    dpt = idxo[0];
    for ( i = 0; i < dpt-1; i++ )
      if ( xo[i] >= xo[i+1] ) return (26); /* x[i] < x[i+1] ǤʤХ
					   ƤȤϤʤɤ줷ʤΤ
					    */
    imode = 0;
  } else {
    /* 4 scalar ξϡָ y ΥǡȤ
     * xa[0], xa[n-1] Ȥ x ˤ롥
     * < 0 ξϡץ󥰼ȿȤ x  */
    dimo = 1;
    dpt  = (int)GetScalar(3);
    imode = 1;
  }
  if ( args > 4 ) {
    /* 5ˤϡ֥ǡ y б x Ǽ
       Хåեˤ */
    if (( outx_id = GetBufferID(4) ) <= 0 ) return (17);
    if ( imode == 1 ) imode = 2;
  }

  if ( dpt <= 0 ) {
    fmode = 1;
    dpt   = (int)((xa[n-1]-xa[0])*get_sampling()) + 1;
  }
  
  if ((yo = CAllocBuffer(dpt)) == NULL) return (8);

  if ( imode != 0 ) {
    if ((xo  = CAllocBuffer(dpt)) == NULL ) return (8);

    DI = (fmode) ? 1.0/get_sampling() : 
      ((dpt > 1) ? (xa[n-1]-xa[0])/(double)(dpt-1) : 0.0);
    for ( i = 0; i < dpt; i++ )
      xo[i] = (double)i * DI + xa[0];
  }

  if ( xa[0] > xo[0] || xa[n-1] < xo[dpt-1])   return (27);
  if ( spline(xa, ya, n, xo, yo, dpt) != 0 ) return (25);

  idxo[0] = dpt;
  ReturnSeries( yo, dimo, idxo );
  if ( outx_id > 0 )
    if ((WriteBuffer( outx_id, dimo, idxo, xo )) == -1 ) return (3);

  return 0;
}


static int spline(double *xa,double *ya,int n,double *x,double *y, int m ){
  double  *y2a;
  double   h, b, a;
  int      i, k, khi, klo, flag = 0;

  if ( n < 3 || xa == NULL || ya == NULL || x == NULL || y == NULL )
    return -1;
  if (( y2a = (double*)emalloc(sizeof(double)*n)) == NULL )
    return -2;
  if (( flag = natural_spline_derivatives( xa, ya, n, y2a )) != 0 )
    return -3;

  if ( xa[0] > x[0] || xa[n-1] < x[m-1]) flag = -4; /* domain error */
  else {
    klo = 0;
    khi = n-1;
    while (khi-klo > 1) {
      k = (khi+klo) >> 1; /* div 2 */
      if ( xa[k] > x[0] ) khi = k;
      else                klo = k;
    }
    
    for ( i = 0; i < m && khi < n ; i++ ) {
      if ( xa[khi] < x[i] ) {
	khi++;
	klo++;
      }
      h = xa[khi] - xa[klo];
/*      if ( h == 0.0 ) { flag = -5; break; } */
      
      a = (- x[i] + xa[khi])/h;
      b = (  x[i] - xa[klo])/h;
      
      y[i] = a*ya[klo]+b*ya[khi]
	+((a*a*a-a)*y2a[klo]+(b*b*b-b)*y2a[khi])*(h*h)/6.0;
    }
  }
  efree(y2a);

  return flag;
}

/*
 * 3ץ饤֤Τ2Ƴؿ롼 
 */
static int natural_spline_derivatives(double *xx,
				      double *yy,int n,double *yy2){
  int     i, k, flag = 0;
  double  p, sig, *uu;
  double  *x, *y, *y2, *u; /* for 1 offset array */

  if (( uu = (double*)emalloc(sizeof(double)*n)) == NULL ) return -1;

  x  = xx -1;  y  = yy -1;  y2 = yy2-1;  u  = uu -1; /* 1 offset */

  y2[1] = u[1] = y2[n] = 0.0;

  for ( i = 2; i <= n-1; i++ ) { /* 3гѥ르ꥺʬ롼 */
    if ( ! (x[i] != x[i+1] && x[i] != x[i-1])) { flag = -1; break; }
    sig   = (x[i]-x[i-1])/(x[i+1]-x[i-1]);
    p     = sig*y2[i-1]+2.0;
    y2[i] = (sig-1.0)/p;
    u[i]  = (y[i+1]-y[i])/(x[i+1]-x[i]) - (y[i]-y[i-1])/(x[i]-x[i-1]);
    u[i]  = (6.0*u[i]/(x[i+1]-x[i-1]) - sig*u[i-1])/p;
  }

  if ( flag == 0 ) { /* 3гѥ르ꥺθ롼 */
    for ( k = n-1; k >= 1; k-- )
      y2[k] = y2[k]*y2[k+1]+u[k];
  }

  efree(uu);

  return flag;
}
#ifdef __cplusplus
}
#endif
