/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: rand_sub.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Uniform random data 
 */
/* #define RMXINT    32768.0 */
#define RMXINT    32767.0

double rnd_uni(double lower,double  upper,int *M,int *J){
  /* M sereise initial data */

  int    k;
  double xx, xxx;
  int    temp;
  
  *J += 1;
  if (*J > 521) *J = 1;
  k = *J - 32;

  if (k <= 0)   k += 521;
  /*
   * Exclusive OR 
   */
  temp    = M[*J-1];
  M[*J-1] = temp ^ M[k-1];
  
  xx = (double) (M[*J - 1]) / (double) RMXINT;
  xxx = xx * (upper - lower) + lower;
  return (xxx);
}
  

/*
 * Normal random data 
 */
double rnd_nor(int itime,double mean,double variance,int *M,int *J){
  static double   x1, x2, s, xx1, xx2;
  static int      IC;
  double          xx, xxx;
  
  if (itime == 0)
    IC = 0;
  
  if (IC != 1) {
    do{
        x1 = rnd_uni(0., 1., M, J);
        x2 = rnd_uni(0., 1., M, J);
	xx1 = 2.0 * x1 - 1.0;
	xx2 = 2.0 * x2 - 1.0;
	s = xx1 * xx1 + xx2 * xx2;
    }
    while(s >= 1);

    xx = xx1 * sqrt(-2.0 * log(s) / s);
    IC = 1;
  } else {
    xx = xx2 * sqrt(-2.0 * log(s) / s);
    IC = 0;
  }

  xxx = xx * sqrt(variance) + mean;
  
#ifdef _DEBUG_ISPP
  printf("x1 :%g x2:%g xx:%g\n", x1, x2, xx);
#endif
  return (xxx);
}

/*
 * function ISGN 
 */
int ISIGN(int a,int b){
  if (a < 0)
    a *= -1;
  if (b < 0)
    a *= -1;
  return (a);
}

/* #define      NRAND     65539 */
#define      NRAND     69069

/*
 * NRAND =  16bit Machine  899 =  32bit Machine  65539 
 */
void Gen_M_series(int init_val,int M[]){
  int i, j, ix, mj, ih, ii, ij;
  int IA[521];
  
  ix = init_val;
  for (i = 0; i < 521; i++) {
    ix *= NRAND;
    IA[i] = ISIGN(1, ix);
#ifdef _DEBUG_ISPP
    printf("IX =%d IA()%d\n", ix, IA[i]);
#endif
  }
  
  for (j = 1; j <= 521; j++) {
    ih = ((j - 1) * 32) % 521 + 1;
    mj = 0;
    
    for (i = 1; i <= 15; i++) {
      ii = (ih + i - 2) % 521 + 1;
      mj = 2 * mj + (IA[ii - 1] - 1) / (-2);
      ij = (ii + 488) % 521 + 1;
#ifdef _DEBUG_ISPP
      printf("ii :%d ij :%d mj :%d\n", ii, ij, mj);
#endif
      IA[ii - 1] *= IA[ij - 1];
    }
    
    M[j - 1] = mj;
#ifdef _DEBUG_ISPP
    printf("M[%d] = %d \N", j - 1, M[j - 1]);
#endif
    ii = (ih + 30) % 521 + 1;
    ij = (ii + 488) % 521 + 1;
    IA[ii - 1] *= IA[ij - 1];
  }
}
#ifdef __cplusplus
}
#endif
