/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: inv.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*******************************
* Visual Process Command Lib.  *
*       ( 2-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : inv            *
*    ( Ver 1.0 : 1993/03/17 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

#ifdef __cplusplus
extern "C" {
#endif

static int   inv (Buffer *x, Buffer *y, int n);

DLLEXPORT int mod_ispp_inv(){
  Buffer *x, *y, *xx, *yy, *xmax;
  int    idx[MAX_INDEX];
  int    dim, a, n, l;

  x = GetSeries( 0, &dim, idx );
  if ( x == NULL )
    return (4);

  switch ( dim ) {

  case 1:
    printf("cannot calculate Series value\n");
    return (24);
    break;

  default:
    if ( idx[dim-2] != idx[dim-1] ) 
      return (7);

    l  = IndexSize( dim, idx );
    n  = idx[dim-1];
    a  = n*n;
    xmax = x + l;
    if (( y = AllocBuffer( l ) ) == NULL )
      return (8);

    for ( xx = x, yy = y; xx < xmax; xx += a, yy += a ) 
      if ( inv( xx, yy, n ) != 1 )
	printf("cannot calculate inverse matrix\n"); 
    ReturnSeries( y, dim, idx );
    FreeBuffer( y );
  }
  FreeBuffer( x );
  return 0;
}

static int inv(Buffer *x,Buffer *y,int n ){
  int    dpt1, dpt2, i, j, k;
  double tmp1;

  for ( i = 0; i < n; i++ ) {
    dpt1 = i*n;
    for ( j = 0; j < n; j++ )
      y[ dpt1+j ] = 0.0;
    y[ dpt1+i ] = 1.0;
  }
  for ( i = 0; i < n; i++ ) {
    dpt2 = i*n;
    for ( j = i+1; j < n; j++ ) {
      dpt1 = j*n;
      if ( fabs(x[dpt1+i]) > fabs(x[dpt2+i]) ) {
	for ( k = 0; k < n; k++ ) {
	  tmp1      = x[dpt1+k];
	  x[dpt1+k] = x[dpt2+k];
	  x[dpt2+k] = tmp1;
	  tmp1      = y[dpt1+k];
	  y[dpt1+k] = y[dpt2+k];
	  y[dpt2+k] = tmp1;
	}
      }
    }
    if ( fabs( x[dpt2+i] ) > DBL_EPSILON ) {
      for ( j = i+1; j < n; j++ )
	x[dpt2+j] /= x[dpt2+i];
      for ( j = 0; j < n; j++ )
	y[dpt2+j] /= x[dpt2+i];
      for ( j = 0; j < n; j++ )
	if ( i != j ) {
	  dpt1 = j*n;
	  for ( k = i+1; k < n; k++ )
	    x[dpt1+k] -= x[dpt2+k] * x[dpt1+i];
	  for ( k = 0; k < n; k++ )
	    y[dpt1+k] -= y[dpt2+k] * x[dpt1+i];
	}
    } else
      return(-1);
  }
  return(1);
}
#ifdef __cplusplus
}
#endif
