/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: interp.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*********************************************
 *  y = interp( M, B1, B2, B3 [, B4])        * 
 *            M  : METHOD (akima, spline)    *
 *            B1 : INPUT TIME BUFFER         *
 * 	      B2 : INPUT DATA BUFFER         *
 *            B3 : DPT or OUTPUT TIME PRESET *
 *            B4 : OUTPUT TIME BUFFER        *
 *            Y  : OUTPUT DATA BUFFER        *
 *********************************************/

#ifdef __cplusplus
extern "C" {
#endif

int ispp_interp_akima();   /* referred to akima.c  */
int ispp_interp_spline();  /* refereed to spline.c */

DLLEXPORT int mod_ispp_interp(){
  int   argc, ret;
  char *method;

  /* check number of arguments */
  argc = GetArgNum();
  if(argc != 4 && argc != 5)
    return 2; /* illegal parameter */

  /* check using method */
  if(strcmp(GetArgType(0),"string") != 0)
    return 2; /* illegal parameter */
  method = GetString(0);
  if(strcmp(method, "akima") == 0 || 
     strcmp(method, "AKIMA") == 0){
    ret = ispp_interp_akima();
  }else if(strcmp(method, "spline") == 0 || 
           strcmp(method, "SPLINE") == 0){
    ret = ispp_interp_spline();
  }else{
    ret = 2; /* illegal parameter */
  }
  return ret;
}

#ifdef __cplusplus
}
#endif
