/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: gauss2.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*******************************
* Visual Process Command Lib.  *
*       ( 2-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*   Prog. Name : gauss2        *
*     ( Ver 1.0 : 1993/03/18 ) *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

#define  PAI M_PI

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_gauss2(){
  Buffer *x, *y, *c;
  double u1, u2, r, a, R11, R12, R22, AA;
  int    dim1, dim2, dim3, i, j, dpt;
  int    index1[MAX_INDEX], index2[MAX_INDEX], index3[MAX_INDEX];

  R11 = GetScalar(2);
  R12 = GetScalar(3);
  R22 = GetScalar(4);
  AA  = GetScalar(5);
  x   = GetSeries(0, &dim1, index1 );
  c   = GetSeries(1, &dim3, index3 );
  if ( x == NULL || index1[0] < 2 || c == NULL || index3[0] < 2 )
    return (7);

  if ( c[0] >= x[0] || c[1] >= x[1] ) {
    printf("illegal position\n");
    return (20);
  }
  dim2 = 2;
  index2[0] = (int)x[0];
  index2[1] = (int)x[1];
  if ((y = AllocBuffer( IndexSize( dim2, index2 ) )) == NULL )
    return (8);

  r = ( R11 * R22 ) - ( R12 * R12 );

  if ( r == 0.0 ) {
    printf("Determinant of covariance matrix should be non zero.\n");
    printf("r11*r22 must differ to r12*r12.\n");
    return (2);
  } 

  a = AA/(2.0*PAI*sqrt(r));
  for ( i = 0 ; i < index2[0] ; i++ ) {
    dpt = i*index2[1];
    for ( j = 0 ; j < index2[1] ; j++ ) {
      u1 = (double)j - c[0];
      u2 = (double)i - c[1];
      y[dpt+j] = a*exp(-((R22*u1*u1-2.0*R12*u1*u2+R11*u2*u2)/(2.0*r)));
    }
  }
  ReturnSeries( y, dim2, index2 );
  FreeBuffer( x );
  FreeBuffer( y );
  FreeBuffer( c );
  return 0;
}
#ifdef __cplusplus
}
#endif
