#
# ispp3.sl
# Two dimension power spectrum
#

x=(1~441)*0;
x:[220]=1;
input=reform(x,(21,21));
wopen(1,"A4",0,0);
origin(20,40);
color("black","black");
size(80,80);
scale("N","A","N","A");
gsolm(input,0.3,0.4,0,0,0,1,0,1,1,"X",1,0,6);

coeftemp=(1~25)*0+1;
coef=reform(coeftemp,(5,5));
output=fir(coef,input);
output2=fir(coef,input,0.0);
origin(20,130);
size(80,80);
scale("N","A","N","A");
gsolm(output2,0.3,0.4,0,0,0,1,0,1,1,"X",1,0,6);

series u[32],v[32];
datp=15;
data=((1~datp)*0,1,1,(1~datp)*0);
x=mul(trans(data),data);
y=x*0;
origin(120,40);
size(80,80);
scale("N","A","N","A");
gsolm(x,0.3,0.4,0,0,0,1,0,1,1,"X",1,0,6);

fftn("P",x,y,u,v);
pw2=power(u,v);
series pw21[32];
for(i=0;i<32;i++){
	tmp1=(0~31)*0;
	tmp=pw2[i];
	tmp1:[16]=tmp:[0];
	tmp1:[0] = tmp:[16];
	for(j=1;j<16;j++){
		tmp1:[j]=tmp:[16-j];
	}
	for(j=1;j<16;j++){
		tmp1:[16+j]=tmp:[32-j];
	}
	pw21[i]=tmp1;
}
series pw22[32];
for(j=0;j<32;j++){
	tmp1=(0~31)*0;
	for(i=0;i<32;i++){
		tmp = pw21[i];
		tmp1:[i]=tmp:[j];
	}
	tmp2=(0~31)*0;
	tmp2:[16]=tmp1:[0];
	tmp2:[0] = tmp1:[16];
	for(i=1;i<16;i++){
		tmp2:[i]=tmp1:[16-i];
	}
	for(i=1;i<16;i++){
		tmp2:[16+i]=tmp1:[32-i];
	}
	pw22[j]=tmp2;
}

origin(120,130);
size(80,80);
scale("N","A","N","A");
gsolm(pw22,0.3,0.4,0,0,0,1,0,1,1,"X",1,0,6);

