#
# ispp1.sl
# Fourier transform
#
# create original data
sampling(4000);
t=0~1999/2000;
a=5*sin(2*PI*20*t)+3;
b=3*sin(2*PI*50*t)+3;
acut=cut(a,0,1023);
bcut=cut(b,0,1023);
nois=nrand(1024,1,0,1);
data=acut+bcut+nois;

wopen(1,"A4",0,0);
color("red","black");
x=0~1023;
origin(20,40);
size(80,50);
scale("N","F","N","F",0,1000,-20,20);
graph(data,x,0,0,0,0,0);
title(1,"Time[sec]","Amplitude");
axis(1,1,"XY","XY",4.5,0,3,200,20,1);
frame();
# label("I",75,45,5.0,0,"original",1);

# remove DC part
data1=dccut(data);
origin(20,110);
size(80,50);
scale("N","F","N","F",0,1000,-20,20);
graph(data1,x,0,0,0,0,0);
title(1,"Time[sec]","Amplitude");
axis(1,1,"XY","XY",4.5,0,3,200,20,1);
frame();
# label("I",75,45,5.0,0,"remove DC part",1);

# windowning
data2=window(data1,1,0);
origin(20,180);
size(80,50);
scale("N","F","N","F",0,1000,-20,20);
graph(data2,x,0,0,0,0,0);
title(1,"Time[sec]","Amplitude");
axis(1,1,"XY","XY",4.5,0,3,200,20,1);
frame();
# label("I",75,45,5.0,0,"hamming window",1);

# fourier trandform
series Rout,Iout;
rei=0~1023*0;
fftc("P",data2,rei,Rout,Iout);
origin(120,40);
size(80,50);
scale("N","F","N","F",0,100,-1000,1000);
graph(Rout,"F",0,0,0,0,0);
ltype(5,1);
graph(Iout,"F",0,0,0,0,0);
title(1,"Frequency[Hz]","Amplitude");
axis(1,1,"XY","XY",4.5,0,3,20,1000,1);
frame();
# label("I",75,45,5.0,0,"fourier trandform",1);

# power spectrum
pw=power(Rout,Iout);
origin(120,110);
size(80,50);
scale("N","F","N","F",0,100,-200000,2000000);
ltype(1,1);
graph(pw,"F",0,0,0,0,0);
title(1,"Frequency[Hz]","Power");
axis(1,1,"XY","XY",4.5,0,3,20,1000000,0);
frame();
# label("I",75,45,5.0,0,"power spectrum");
