/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: bpbtw.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"
/*****************************************************************
 *  ( Band-Pass )
 *  ХɣɣҥХɥѥե륿߷
 *  BPBTW fc1,fc2,n,b1,b2,b3,b4,b5
 *  fc1.....åȥղ¼ȿȿˡ
 *  fc2.....åȥվ¼ȿ
 *  n.......ե륿
 *  b1......¿
 *  b2......
 *  b3......˼¿
 *  b4......˵
 *  
 *  '92/3/25
 *  						 Żҡʳ
 *						'92/6/21
 *						TODA @MCT
 *****************************************************************/
#define PAI 	M_PI
#define MAXORD	101

#ifdef __cplusplus
extern "C" {
#endif

static void btwbp (int n, double fc1, double fc2, double *are, double *aim,
		   double *zre, double *zim, int *oinc, double *gain );

int ispp_butwmake_bandpass(){
  double       *fc;
  int           fcdim, fcidx[MAX_INDEX];
  double        fc1, fc2,fs, gain;
  int	        i, j, n, n1, oinc;
  double 	are[MAXORD],aim[MAXORD];
  double	zre[MAXORD],zim[MAXORD];
  
  int          dim, idx[MAX_INDEX];
  int          b1,b2,b3,b4;
  /* ((((((((((((((((((((((ǡɤ߹ߡ))))))))))))))))))))))) */
  
  fs = get_sampling();
  
  fc  = GetSeries(1,&fcdim, fcidx);
  if(fcdim != 1) return 24;    /* illegal buffer dimension */
  if(fcidx[0] != 2) return 17; /* illegal buffer */
  fc1 = fc[0];
  fc2 = fc[1];
  FreeBuffer(fc);
  n   = (int)GetScalar(2);
  b1  = GetBufferID(3);
  b2  = GetBufferID(4);
  b3  = GetBufferID(5);
  b4  = GetBufferID(6);
  
  if ( b1 == 0 || b2 == 0 || b3 == 0 || b4 == 0 )
    return (3);
  
  /* .............缡ʾϤǤޤ */
  if ( n > MAXORD ){
    printf("Filter Order is Too Large\n");
    return (2);
  }
  
  if ((fc1<=0)||(fc2<=fc1)){
    printf("Illegal Cut-off Frequency\n"); 
    return (2);
  }

  if (n<=0)
    return (2);

  /* (((((((((((((((((((((((    η׻)))))))))))))))))))))))) */
        
  fc1=2.0*fc1/fs;
  fc2=2.0*fc2/fs;

  btwbp( n,fc1,fc2,are,aim,zre,zim,&oinc,&gain );

  /* (((((((((((((((((((((((    񤭹    )))))))))))))))))))))))))))) */
  /* ...................			*/
  n1=n/2;
  n1=n1*2;
  
  dim=1;
  
  idx[0]=n1;
  WriteBuffer(b1,dim,idx,zre);
  WriteBuffer(b2,dim,idx,zim);
  /* ...................				*/
  
  if ( oinc == n/2 )
    for ( i = n/2, j = 0; i < n; i++, j++ ) {
      are[i] = are[j];
      aim[i] = -aim[j];
    }
  else
    for ( i = n/2+1, j = 1; i < n; i++, j++ ) {
      are[i] = are[j];
      aim[i] = -aim[j];
    } 
  
  WriteBuffer(b3,dim,&n,are);
  WriteBuffer(b4,dim,&n,aim);
  /* ...................gain			 */
  
  ReturnScalar(gain);
  
  return 0;
}
/*********************************************************************
  
  η׻
  :
  n.............ե륿
  fc1...........åȥղȿ
  fc2...........åȥվȿ
  ϡ
  are...........˼ºɸ
  aim...........˵ɸ
  zre...........ºɸ
  zim...........ɸ
  oinc..........ɽ
  gain..........ե륿
  **********************************************************************/
static void btwbp(int n,double fc1,double fc2,double *are,double *aim,
		  double *zre, double *zim,int *oinc,double *gain ){
  double	tsa1, tsa2, tsb1, tsb2, tsg;
  double	tza1, tza2, tzb1, tzb2, tzg;
  double	a, omeg0, x, sig, omeg, z, u, v;
  double	tzb, tzc, g0, g1, g2;
  int	n1, i, cas, im;
  /* ................Ϣ³ȿؤѴʥץס */
  fc1 = 4.0*tan(0.5*PAI*fc1);
  fc2 = 4.0*tan(0.5*PAI*fc2);
  /* <<<<<<<<<<<<<<<<<<<<<<<<<ãؿη׻>>>>>>>>>>>>>>>>>>>>>>>>> */
  n1=n/2;
  /* .................񤭹 */
  for( i=0 ; i<n1 ; i++ ){
    zre[i]=1.0;
    zim[i]=0.0;
  }
  for( i =n1 ; i< 2*n1 ; i++){
    zre[i] = -1.0 ;
    zim[i] = 0.0 ;
  }
  /* ...............ʬ */
  cas = n1%2;
  cas++;
  switch( cas ){
    
    /* ((((((((((((((((((((((((())))))))))))))))))))))))))))))) */
    
  case 1:
    /*						*/
    *oinc = 0 ;
    *gain = 1.0 ;
    for( i=1 ; i<=(n1-1) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n1)));
      omeg0 = sqrt( fc1*fc2 );
      x = (fc2-fc1)/omeg0 ;
      sig = a*x / 2.0;
      omeg = ( x*sqrt(4.0-a*a) )/2.0;
      z = 4.0 - sig*sig + omeg*omeg;
      u = sqrt((z/2.0)+sqrt((z*z/4.0)+sig*sig*omeg*omeg));
      v = sig*omeg/u;
      tsg = fc2-fc1;
      tsa1 = omeg0*(sig+v);
      tsb1 = omeg0*omeg0*((sig+v)*(sig+v)+(omeg+u)*(omeg+u))/4.0;
      tsa2 = omeg0*(sig-v);
      tsb2 = omeg0*omeg0*((sig-v)*(sig-v)+(omeg-u)*(omeg-u))/4.0;
      g1 = 1.0/(16.0+tsa1*4.0+tsb1);
      g2 = 1.0/(16.0+tsa2*4.0+tsb2);
      tza1 = 2.0*g1*(tsb1-16.0);
      tzb1 = g1*(16.0-tsa1*4.0+tsb1);
      tza2 = 2.0*g2*(tsb2-16.0);
      tzb2 = g2*(16.0-tsa2*4.0+tsb2);
      tzg  = g1*g2*(tsg*4.0)*(tsg*4.0);
      /*						    */
      *gain *= tzg;
      
      /* .........ãؿȾ    */
      
      if( tza1*tza1-4.0*tzb1 < 0.0 )
	im = 1;
      else
	im = 2;
      switch (im){
	/* ....................  */
      case 1:
	are[*oinc] = -tza1/2.0;
	aim[*oinc] = sqrt(4.0*tzb1-tza1*tza1)/2.0;
	*oinc += 1;
	break;
	/* ....................º  */
      case 2:
	are[*oinc] = (-tza1+sqrt(tza1*tza1-4.0*tzb1))/2.0;
	are[*oinc+1] = (-tza1-sqrt(tza1*tza1-4.0*tzb1))/2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
      
      /* ......ãؿʸȾ */
      if( tza2*tza2-4.0*tzb2 < 0.0 )
	im = 1;
      else
	im = 2;
      switch (im ){
	/* .................... */
      case 1:
	are[*oinc] = -tza2/2.0;
	aim[*oinc] = sqrt(4.0*tzb2-tza2*tza2)/2.0;
	*oinc += 1;
	break;
	/* ....................º */
      case 2:
	are[*oinc] = (-tza2+sqrt(tza2*tza2-4.0*tzb2))/2.0;
	are[*oinc+1] = (-tza2-sqrt(tza2*tza2-4.0*tzb2))/2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
    
    /* ((((((((((((((((((((((((()))))))))))))))))))))))))))))))) */
    
  case 2:
    /*						*/
    *oinc = 0;
    *gain = 1.0;
    /* ...... */
    g0 = 1.0/(16.0+4.0*(fc2-fc1)+fc1*fc2);
    tzg = g0*4.0*(fc2-fc1);
    tzb = 2.0*g0*(fc1*fc2-16.0);
    tzc = g0*(16.0-4.0*(fc2-fc1)+fc1*fc2);
    *gain *= tzg;
    /*      						    */
    if( tzb*tzb-4.0*tzc < 0.0 )
      im = 1;
    else
      im = 2;
    switch (im){
      
      /* ................ */
    case 1:
      are[*oinc] = -tzb/2.0;
      aim[*oinc] = sqrt(4.0*tzc-tzb*tzb)/2.0;
      *oinc += 1;
      break;
      
      /* ................º */
    case 2:
      are[*oinc] = (-tzb+sqrt(tzb*tzb-4.0*tzc))/2.0;
      are[*oinc+1] = (-tzb-sqrt(tzb*tzb-4.0*tzc))/2.0;
      aim[*oinc] = 0.0;
      aim[*oinc+1] = 0.0;
      *oinc += 2;
      break;
    }
    
    /* .....̹ */
    for( i=1 ; i<=(n1-2) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n1)));
      omeg0 = sqrt( fc1*fc2 );
      x = (fc2-fc1)/omeg0 ;
      sig = a*x / 2.0;
      omeg = ( x*sqrt(4.0-a*a) )/2.0;
      z = 4.0 - sig*sig + omeg*omeg;
      u = sqrt((z/2.0)+sqrt((z*z/4.0)+sig*sig*omeg*omeg));
      v = sig*omeg/u;
      tsg = fc2-fc1;
      tsa1 = omeg0*(sig+v);
      tsb1 = omeg0*omeg0*((sig+v)*(sig+v)+(omeg+u)*(omeg+u))/4.0;
      tsa2 = omeg0*(sig-v);
      tsb2 = omeg0*omeg0*((sig-v)*(sig-v)+(omeg-u)*(omeg-u))/4.0;
      g1 = 1.0/(16.0+tsa1*4.0+tsb1);
      g2 = 1.0/(16.0+tsa2*4.0+tsb2);
      tza1 = 2.0*g1*(tsb1-16.0);
      tzb1 = g1*(16.0-tsa1*4.0+tsb1);
      tza2 = 2.0*g2*(tsb2-16.0);
      tzb2 = g2*(16.0-tsa2*4.0+tsb2);
      tzg  = g1*g2*(tsg*4.0)*(tsg*4.0);
      /*						    */
      *gain *= tzg;
      
      /* .........̹Ⱦ    */
      
      if( tza1*tza1-4.0*tzb1 < 0.0 )
	im = 1;
      else
	im = 2;
      switch (im ){
	/* .................... */
      case 1:
	are[*oinc] = -tza1/2.0;
	aim[*oinc] = sqrt(4.0*tzb1-tza1*tza1)/2.0;
	*oinc += 1;
	break;
	/* ....................º */
      case 2:
	are[*oinc] = (-tza1+sqrt(tza1*tza1-4.0*tzb1))/2.0;
	are[*oinc+1] = (-tza1-sqrt(tza1*tza1-4.0*tzb1))/2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
      
      /* ......̹ʸȾ    */
      if( tza2*tza2-4.0*tzb2 < 0.0 )
	im = 1;
      else
	im = 2;
      switch (im ){
	/* .................... */
      case 1:
	are[*oinc] = -tza2/2.0;
	aim[*oinc] = sqrt(4.0*tzb2-tza2*tza2)/2.0;
	*oinc += 1;
	break;
	/* ....................º */
      case 2:
	are[*oinc] = (-tza2+sqrt(tza2*tza2-4.0*tzb2))/2.0;
	are[*oinc+1] = (-tza2-sqrt(tza2*tza2-4.0*tzb2))/2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
  }
}

#ifdef __cplusplus
}
#endif
