/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: arand.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "rand_sub.h"
/**********************************************************
 * 
 * "ARAND  DPT , INIT , DISTRY , RMIN , RMAX "
 * 
 * DPT    : output data point
 * INIT   : initial value
 * DISTRY : distribution function's value
 * RMIN   : minimum of distribution function's range
 * RMAX   : maximum of distribution function's range
 *	
 *    Date May 26th, 1994 by DORA(T.Hayasaka)
 ***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_arand()
{
  int          dpt, fdpt;
  int          init, ii;
  Buffer       *distri;
  Buffer       lower, upper, rmax, rmin, dx;
  Buffer       *work, *awork, *xwork;
  register int i;
  int          dim = 1, index[MAX_INDEX];
  int          dim_dist, index_dist[MAX_INDEX];
  
  int          M[521], J;

  index[0] = dpt = (int)GetScalar(0);
  init = (int)GetScalar(1);
  distri = GetSeries(2,&dim_dist,index_dist);
  rmin = GetScalar(3);
  rmax = GetScalar(4);

  fdpt = index_dist[0];
  if (( awork = AllocBuffer(dpt) ) == NULL )
    return (4);
  if (( work = AllocBuffer(dpt) ) == NULL )
    return (4);
  if (( xwork = AllocBuffer(fdpt) ) == NULL )
    return (4);

  dx = (rmax - rmin) / (Buffer)fdpt;
  xwork[0] = dx + rmin;
  for (i = 1; i < fdpt; i++){
    xwork[i] = xwork[i-1] + dx;
  }
  Gen_M_series(init, M);
  J = 0;
  
#ifdef _DEBUG_ISPP
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  lower = 0.0;
  upper = 1.0;
  for (i = 0; i < dpt; i++) {
    work[i] = rnd_uni(lower, upper, M, &J);
  }
  for (i = 0; i < dpt; i++) {
    ii = 0;
    do{
      ii++;
    }
    while(work[i] > distri[ii]);
    if (work[i] == distri[ii]) {
      awork[i] = xwork[ii];
    }else{
      awork[i]=((work[i]-distri[ii-1])/(distri[ii]-distri[ii-1]))*dx+xwork[ii-1];
    }
  }
  ReturnSeries(awork, dim, index);
  FreeBuffer(awork);
  FreeBuffer(xwork);
  FreeBuffer(work);
  return 0;
}

#ifdef __cplusplus
}
#endif
