/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/lib/font.h,v 1.1 2004/07/21 04:55:46 orrisroot Exp $ */

#ifndef LIBGPM_FONT_H
#define LIBGPM_FONT_H

#ifdef  GPMCMD_C_SOURCE

#ifdef __cplusplus
extern "C" {
#endif

/* GPM Center Symbol and GPM Font Data File */

#define EOD -128  /* End Of Data            */
#define FIL -127  /* FILl closed lines      */
#define EPL -126  /* End of Plots           */
#define MOV -125  /* pen Move               */
#define PLT -124  /* PLoT line              */
#define CIR -123  /* CIRcle                 */
#define FCR -122  /* Filled CiRcle          */
#define FCB -120  /* Fill CiRcle Black      */
#define POL -121  /* Plot Open Line         */
#define FLB -119  /* Fill Closed Line Black */

/* Format of Data                      */
/* Ope, data,...., EOD : 1 charactor   */
/* Ope: FIL, MOV, PLT, CIR, FCR        */
/* Format of each Operation :          */
/*    FIL: FIL,x0,y0,x1,y1,...,EPL     */
/*    POL: POL,x0,y0,x1,y1,...,EPL     */
/*    MOV: MOV,x,y                     */
/*    PLT: PLT,x,y                     */
/*    CIR: CIR,x,y,xr,yr               */
/*    FCR: FCR,x,y,xr,yr               */
/*    FCB: FCR,x,y,xr,yr               */

/* Center Symbols Data : 17 Symbols    */
/* x, y max value : -50, 50            */
#define SYMBOL_RANGE 100.0
static int SYM00[] = { POL,-50,-50,-50, 50, 50, 50, 50,-50,-50,-50,EPL,EOD};
static int SYM01[] = { CIR,  0,  0, 50, 50, EOD};
static int SYM02[] = { POL,  0, 50,-43,-26, 43,-26,  0, 50,EPL,EOD};
static int SYM03[] = { MOV,  0, 50,PLT,  0,-50,MOV,-50,  0,PLT, 50,  0,EOD};
static int SYM04[] = { MOV,-35, 35,PLT, 35,-35,MOV,-35,-35,PLT, 35, 35,EOD};
static int SYM05[] = { POL,  0, 50,-50,  0,  0,-50, 50,  0,  0, 50,EPL,EOD};
static int SYM06[] = { FIL,-50, 50,-50,-50, 50,-50, 50, 50,-50, 50,EPL,EOD};
static int SYM07[] = { FCR, 0, 0, 50, 50, EOD};
static int SYM08[] = { FIL,  0, 50,-43,-26, 43,-26,  0, 50,EPL,EOD};
static int SYM09[] = { POL,  0,-50,-43, 26, 43, 26,  0,-50,EPL,EOD};
static int SYM10[] = { FIL,  0,-50,-43, 26, 43, 26,  0,-50,EPL,EOD};
static int SYM11[] = { FIL,  0, 50,-50,  0,  0,-50, 50,  0,  0, 50,EPL,EOD};
static int SYM12[] = { FLB,-50,-50,-50, 50, 50, 50, 50,-50,-50,-50,EPL,
		       POL,-50,-50,-50, 50, 50, 50, 50,-50,-50,-50,EPL,EOD};
static int SYM13[] = { FCB,  0,  0, 50, 50, CIR,  0,  0, 50, 50, EOD};
static int SYM14[] = { FLB,  0, 50,-43,-26, 43,-26,  0, 50,EPL,
		       POL,  0, 50,-43,-26, 43,-26,  0, 50,EPL,EOD};
static int SYM15[] = { FLB,  0, 50,-50,  0,  0,-50, 50,  0,  0, 50,EPL,
		       POL,  0, 50,-50,  0,  0,-50, 50,  0,  0, 50,EPL,EOD};
static int SYM16[] = { FLB,  0,-50,-43, 26, 43, 26,  0,-50,EPL,
		       POL,  0,-50,-43, 26, 43, 26,  0,-50,EPL,EOD};

#define MAX_SYMBOL_NUM 17
static int *GPMsymbol[MAX_SYMBOL_NUM] = {
  SYM00, SYM01, SYM02, SYM03, SYM04, SYM05, SYM06, SYM07, SYM08,
  SYM09, SYM10, SYM11, SYM12, SYM13, SYM14, SYM15, SYM16};

#define FONT_RANGE 100.0

/* Font Data */
static int CH20[] = { /* brank */
  EOD};
static int CH21[] = { /* exclam */
  FIL,51,11,47,11,44,10,41,8,39,6,39,4,40,1,43,-1,47,-2,
  53,-2,57,-1,60,1,62,3,62,6,60,8,57,10,53,11,51,11,EPL,
  FIL,44,57,58,57,54,19,47,19,44,57,EPL,EOD};
static int CH22[] = { /* double quote */
  FIL,27,56,42,56,40,28,29,28,27,56,EPL,
  FIL,58,56,74,56,72,28,60,28,58,56,EPL,EOD};
static int CH23[] = { /* numbersign */
  FIL,34,66,42,66,35,-5,28,-5,34,66,EPL,
  FIL,13,45,87,45,87,39,13,39,13,45,EPL,
  FIL,13,22,87,22,87,16,13,16,13,22,EPL,
  FIL,66,66,74,66,67,-5,60,-5,66,66,EPL,EOD};
static int CH24[] = { /* dollar */
  FIL,72,55,80,55,79,47,80,41,81,36,73,35,71,42,67,46,63,48,58,50,50,50,
  41,50,34,48,30,44,30,39,32,36,37,33,50,30,50,25,37,28,30,30,24,33,
  21,37,21,44,24,48,29,51,37,54,47,55,54,55,61,54,68,52,71,52,72,55,EPL,
  FIL,50,30,67,27,76,24,80,21,82,18,82,12,79,9,74,5,66,3,58,2,50,1,42,2,
  33,3,30,4,28,4,27,3,27,1,19,1,19,12,17,20,26,20,27,16,32,11,36,8,42,6,
  50,6,59,6,67,8,72,12,74,15,73,18,70,21,61,24,50,25,50,30,EPL,
  FIL,47,65,54,65,54,-14,47,-14,47,65,EPL,EOD};
static int CH25[] = { /* percent */
  FIL,63,25,64,21,58,19,53,14,53,10,56,6,64,3,71,3,
  78,6,82,10,82,14,78,18,71,21,64,21,63,25,72,25,
  79,23,85,20,90,14,90,9,84,3,77,0,67,-1,58,0,
  51,2,45,8,44,14,48,20,55,23,63,25,EPL,
  FIL,27,61,28,57,22,55,17,50,17,46,20,42,28,39,35,39,
  42,42,46,46,46,50,42,54,35,57,28,57,27,61,36,61,
  43,59,49,56,54,50,54,45,48,39,41,36,31,35,22,36,
  15,38,9,44,8,50,12,56,19,59,27,61,EPL,
  FIL,15,24,83,42,86,37,19,19,15,24,EPL,EOD};
static int CH26[] = { /* ampersand */
  FIL,75,52,71,51,66,51,58,53,50,54,40,53,35,51,29,48,28,44,28,40,31,35,71,0,
  90,0,90,5,77,5,40,37,37,42,37,44,40,47,46,49,53,49,60,47,67,44,75,52,EPL,
  FIL,89,23,89,28,73,28,65,15,59,10,52,6,47,5,40,5,36,6,31,9,29,12,28,16,
  29,19,34,24,44,28,41,31,28,28,22,24,18,19,17,14,18,9,24,4,31,1,38,-1,44,-1,
  52,1,59,3,68,9,74,17,79,23,89,23,EPL,EOD};
static int CH27[] = { /* apostorophe */
  FIL,42,56,60,56,42,32,30,32,42,56,EPL,EOD};
static int CH28[] = { /* left paren */
  FIL,78,65,67,51,61,40,58,32,58,23,61,15,65,6,77,-10,69,-10,60,0,54,9,
  49,19,48,28,49,36,54,47,61,57,69,65,78,65,EPL,EOD};
static int CH29[] = { /* right paren */
  FIL,22,65,33,51,39,40,42,32,42,23,39,15,35,6,23,-10,31,-10,40,0,46,9,
  51,19,52,28,51,36,46,47,39,57,31,65,22,65,EPL,EOD};
static int CH2A[] = { /* asterisk */
  FIL,44,56,55,56,54,41,78,47,81,40,56,37,73,25,63,20,
  49,33,35,20,26,25,41,36,18,40,21,47,45,41,44,56,EPL,EOD};
static int CH2B[] = { /* plus */
  FIL,45,53,54,53,54,33,89,33,89,28,54,28,54,7,45,7,
  45,28,10,28,10,33,45,33,45,53,EPL,EOD};
static int CH2C[] = { /* comma */
  FIL,41,13,59,13,41,-11,29,-11,41,13,EPL,EOD};
static int CH2D[] = { /* minus */
  FIL,31,32,67,32,67,26,31,26,31,32,EPL,EOD};
static int CH2E[] = { /* period */
  FIL,48,12,53,12,59,10,62,8,63,5,62,2,60,1,57,0,
  54,-1,50,-2,45,-1,41,0,38,2,37,4,37,6,39,9,
  43,11,46,12,48,12,EPL,EOD};
static int CH2F[] = { /* slash */
  FIL,78,71,85,68,22,-13,15,-11,78,71,EPL,EOD};
static int CH30[] = { /* 0 */
  FIL,49,62,60,61,67,59,73,55,77,51,80,42,82,35,82,27,
  80,20,78,12,73,6,68,3,62,1,59,0,50,-1,46,3,
  56,4,63,7,68,11,71,20,73,28,73,35,71,43,68,50,
  63,55,56,57,50,58,47,57,49,62,EPL,
  FIL,52,62,50,58,44,57,38,55,33,52,31,48,28,39,27,32,
  28,22,32,12,35,8,40,5,47,3,52,3,50,-1,42,-1,
  32,3,26,8,21,14,19,20,18,31,19,40,22,49,29,57,
  35,60,41,61,48,62,52,62,EPL,EOD};
static int CH31[] = { /* 1 */
  FIL,17,53,49,62,55,62,55,5,84,5,84,0,18,0,18,5,
  47,5,47,57,20,49,17,53,EPL,EOD};
static int CH32[] = { /* 2 */
  FIL,17,47,17,54,25,58,35,61,43,62,51,62,59,61,68,58,
  73,54,76,50,78,47,78,40,72,32,61,24,24,5,70,5,
  70,15,78,15,78,0,14,0,14,5,61,31,68,38,70,43,
  68,49,64,52,58,55,51,57,42,57,33,55,28,52,26,50,
  26,47,17,47,EPL,EOD};
static int CH33[] = { /* 3 */
  FIL,16,56,29,60,37,62,45,62,56,61,64,58,70,54,73,50,
  73,44,70,39,66,36,61,33,52,32,39,35,50,35,59,38,
  63,43,64,48,61,52,56,56,48,57,41,57,34,57,20,52,
  16,56,EPL,
  FIL,39,35,61,33,69,30,76,25,78,20,78,14,75,9,69,4,
  60,1,51,-1,37,-1,25,1,14,4,18,9,29,6,37,4,
  49,3,60,6,66,10,69,15,69,19,67,23,63,27,57,29,
  48,30,39,30,39,35,EPL,EOD};
static int CH34[] = { /* 4 */
  FIL,65,19,80,19,80,15,65,15,65,5,80,5,80,0,36,0,
  36,5,57,5,57,15,12,15,12,21,53,62,57,62,57,56,
  21,19,57,19,57,62,65,62,65,19,EPL,EOD};
static int CH35[] = { /* 5 */
  FIL,21,60,76,60,76,56,28,56,28,35,38,38,49,39,59,38,
  70,34,76,30,81,23,81,17,79,12,75,6,67,2,57,0,
  44,-1,32,0,14,3,18,8,31,5,42,4,55,4,63,6,
  69,11,72,15,72,21,69,27,63,31,55,33,47,34,36,33,
  24,29,21,30,21,60,EPL,EOD};
static int CH36[] = { /* 6 */
  FIL,82,62,82,57,59,57,48,55,40,51,33,46,29,40,27,29,
  27,24,17,20,17,29,19,38,23,45,30,52,39,58,54,61,
  66,62,82,62,EPL,
  FIL,20,25,29,31,35,34,41,36,51,37,60,36,67,34,74,30,
  79,23,80,18,79,11,73,6,66,1,55,-1,45,-1,35,1,
  28,5,22,10,19,15,17,20,18,23,31,26,26,21,30,12,
  36,7,43,4,50,4,59,4,65,7,69,12,71,16,70,21,
  66,27,61,30,54,32,48,32,41,31,33,28,29,24,20,25,EPL,EOD};
static int CH37[] = { /* 7 */
  FIL,16,47,16,60,81,60,81,56,49,0,39,0,72,56,24,56,
  24,47,16,47,EPL,EOD};
static int CH38[] = { /* 8 */
  FIL,46,34,41,29,33,32,25,35,21,40,20,45,20,48,24,55,
  33,60,45,62,55,62,66,60,73,57,78,53,80,47,80,42,
  76,36,70,33,60,29,54,34,61,35,69,40,71,44,71,48,
  68,52,64,55,58,57,49,58,41,57,33,54,29,49,29,43,
  33,38,38,35,46,34,EPL,
  FIL,46,34,46,29,41,28,34,25,28,20,27,15,29,11,35,6,
  43,4,52,3,61,5,67,8,71,11,73,15,72,21,66,25,
  61,27,46,29,46,34,54,34,65,31,74,28,82,20,82,14,
  80,9,72,3,63,0,50,-1,37,0,28,3,21,8,18,13,
  18,18,21,24,29,29,41,33,46,34,EPL,EOD};
static int CH39[] = { /* 9 */
  FIL,70,41,76,38,67,31,60,27,52,25,43,24,35,25,24,29,
  17,35,15,39,14,44,16,50,22,56,31,61,39,62,46,62,
  56,61,65,57,71,52,76,46,78,40,68,39,67,46,62,52,
  56,55,48,57,39,57,33,55,27,52,24,46,24,40,30,33,
  38,29,48,29,56,31,63,34,70,41,EPL,
  FIL,14,4,14,-1,35,-1,50,2,58,4,69,12,75,22,77,29,
  78,40,68,39,68,31,66,23,61,16,54,10,48,7,34,4,
  14,4,EPL,EOD};
static int CH3A[] = { /* colon */
  FIL,49,39,56,39,61,37,63,34,63,32,62,29,58,27,53,26,
  49,26,45,26,41,27,39,29,38,31,38,33,38,35,40,37,
  44,39,49,39,EPL,
  FIL,49,12,56,11,61,9,63,7,63,5,62,2,58,-1,53,-2,
  49,-2,45,-1,41,0,39,2,37,4,37,6,38,8,41,10,
  44,11,49,12,EPL,EOD};
static int CH3B[] = { /* semi colon */
  FIL,50,39,57,38,61,36,63,33,63,30,59,27,55,26,50,26,
  45,26,40,28,37,31,37,34,40,37,46,39,50,39,EPL,
  FIL,43,13,61,13,42,-11,29,-11,43,13,EPL,EOD};
static int CH3C[] = { /* less */
  FIL,88,54,91,49,28,31,91,14,88,9,10,31,88,54,EPL,EOD};
static int CH3D[] = { /* equal */
  FIL,10,24,89,24,89,19,10,19,10,24,EPL,
  FIL,10,42,89,42,89,37,10,37,10,42,EPL,EOD};
static int CH3E[] = { /* greater */
  FIL,12,53,90,31,12,8,9,13,72,31,9,48,12,53,EPL,EOD};
static int CH3F[] = { /* question */
  FIL,29,43,20,43,20,54,34,56,46,57,55,57,67,54,74,50,
  78,45,80,40,77,34,71,30,65,27,49,24,49,18,41,18,
  41,28,59,31,66,34,70,38,70,43,67,47,61,51,54,52,
  40,52,29,50,29,43,EPL,
  FIL,47,10,54,8,56,5,55,2,52,0,46,-2,39,-1,36,0,
  33,2,33,6,37,9,41,10,47,10,EPL,EOD};
static int CH40[] = { /* atmark */
  FIL,86,10,89,6,69,0,50,-1,37,-1,22,3,12,10,7,16,
  6,21,5,30,10,39,18,47,31,52,44,54,61,54,78,50,
  88,44,95,34,94,26,90,17,82,12,76,16,84,21,86,30,
  85,39,75,46,62,50,44,50,28,46,19,39,14,31,15,20,
  19,13,31,6,44,3,61,4,71,6,86,10,EPL,
  FIL,62,32,63,37,56,40,48,40,41,38,35,34,30,27,29,20,
  31,15,36,11,44,10,50,12,59,16,57,25,48,16,44,15,
  39,16,37,19,37,23,41,31,48,35,54,35,58,32,57,26,62,32,EPL,
  FIL,64,40,73,40,65,23,64,19,67,16,71,15,79,17,86,18,
  82,12,74,11,69,10,64,12,56,15,55,23,64,40,73,40,EPL,EOD};
static int CH41[] = { /* A */
  FIL,18,56,54,56,89,5,98,5,98,0,63,0,63,5,80,5,
  71,19,28,19,31,23,68,23,50,51,18,5,35,5,35,0,
  1,0,1,5,10,5,41,52,18,52,18,56,EPL,EOD};
static int CH42[] = { /* B */
  FIL,7,57,55,57,66,56,73,54,81,50,84,45,84,40,82,35,
  76,32,71,30,64,31,56,32,67,34,73,37,76,41,74,46,
  71,49,65,51,56,52,7,52,7,57,EPL,
  FIL,29,32,57,32,71,30,80,28,86,24,89,21,90,16,88,10,
  84,6,78,3,73,2,65,1,56,0,7,0,7,5,20,5,
  20,52,29,52,29,5,62,5,72,7,79,10,82,15,80,20,
  73,24,63,27,53,27,29,27,29,32,EPL,EOD};
static int CH43[] = { /* C */
  FIL,90,58,90,44,92,39,83,38,82,42,77,48,66,53,53,53,
  40,51,29,45,23,38,20,31,21,24,24,16,31,10,41,6,
  51,4,63,4,76,6,86,10,95,14,100,10,92,6,82,2,
  71,0,59,-1,50,-1,38,1,29,5,20,10,15,17,12,22,
  11,29,13,38,18,45,28,52,41,57,51,58,63,58,75,55,
  81,53,83,58,90,58,EPL, EOD};
static int CH44[] = { /* D */
  FIL,6,57,27,57,27,0,5,0,5,5,19,5,19,52,5,52,
  5,57,7,57,EPL,
  FIL,26,57,51,57,68,56,76,53,83,49,87,44,91,36,92,34,
  92,28,91,23,89,17,85,11,79,6,71,3,63,1,56,0,
  24,0,24,5,41,5,60,6,69,8,77,14,81,22,82,33,
  81,38,77,43,71,48,67,50,59,52,54,52,25,52,25,57,EPL,EOD};
static int CH45[] = { /* E */
  FIL,33,51,33,32,59,32,59,39,67,39,67,19,60,19,60,27,
  32,27,32,4,83,4,83,18,91,18,91,-1,9,-1,9,4,
  24,4,24,51,9,51,9,56,91,56,91,38,82,38,80,51,
  33,51,EPL,EOD};
static int CH46[] = { /* F */
  FIL,11,56,91,56,91,38,84,38,82,51,33,51,33,32,62,32,
  62,40,69,40,69,20,62,20,62,27,33,27,33,5,57,5,
  57,0,11,0,11,5,25,5,25,51,11,51,11,56,EPL,EOD};
static int CH47[] = { /* G */
  FIL,87,58,87,39,79,38,78,42,74,46,69,50,60,53,48,53,
  41,52,34,50,28,48,22,42,18,37,17,33,18,23,21,15,
  31,8,38,5,48,3,59,4,70,5,79,6,79,20,55,20,
  55,25,96,25,96,20,88,20,88,3,69,0,54,-2,41,-1,
  32,1,18,7,13,13,10,19,7,26,8,35,11,42,20,50,
  32,55,41,58,50,58,64,57,76,52,78,58,87,58,EPL,EOD};
static int CH48[] = { /* H */
  FIL,81,51,81,5,93,5,93,0,60,0,60,5,72,5,72,26,
  27,26,27,5,39,5,39,0,6,0,6,5,18,5,18,52,
  6,52,6,57,39,57,39,52,27,52,27,32,72,32,72,52,
  60,52,60,57,93,57,93,52,81,52,81,52,EPL,EOD};
static int CH49[] = { /* I */
  FIL,83,57,83,52,55,52,55,5,83,5,83,0,16,0,16,5,
  44,5,44,52,16,52,16,57,83,57,EPL,EOD};
static int CH4A[] = { /* J */
  FIL,96,56,96,51,75,51,75,18,74,12,72,8,69,4,63,2,
  54,-1,48,-1,37,-1,29,1,11,5,10,27,18,27,20,12,
  23,10,26,7,37,5,47,4,56,5,61,7,64,12,65,15,
  65,51,34,51,34,56,95,56,EPL,EOD};
static int CH4B[] = { /* K */
  FIL,32,51,32,29,74,51,60,51,60,56,93,56,93,51,85,51,
  49,30,59,28,68,22,75,15,82,5,97,5,97,0,76,0,
  69,11,60,19,53,24,43,27,32,21,32,5,46,5,46,0,
  9,0,9,5,23,5,23,51,10,51,10,56,46,56,46,51,
  32,51,EPL,EOD};
static int CH4C[] = { /* L */
  FIL,36,51,36,5,82,5,83,25,92,25,90,0,9,0,9,5,
  25,5,25,51,9,51,9,56,55,56,55,51,36,51,EPL,EOD};
static int CH4D[] = { /* M */
  FIL,87,51,89,5,99,5,99,0,63,0,63,5,82,5,79,51,
  76,51,54,14,44,14,23,51,20,51,18,5,36,5,35,0,
  1,0,1,5,10,5,13,51,1,51,1,56,30,56,48,23,
  50,23,71,57,97,56,97,51,87,51,EPL,EOD};
static int CH4E[] = { /* N */
  FIL,87,51,87,-1,72,-1,28,51,26,51,26,5,44,5,44,0,
  5,0,5,5,17,5,17,51,5,51,5,56,33,56,76,5,
  79,5,79,51,60,51,60,56,97,56,97,51,87,51,EPL,EOD};
static int CH4F[] = { /* O */
  FIL,50,58,60,57,68,56,78,51,84,47,89,41,91,36,92,31,
  92,25,82,25,82,33,81,38,76,43,73,46,66,50,57,53,
  50,53,43,53,32,50,25,46,20,41,17,35,17,24,7,24,
  7,32,8,36,11,42,18,49,25,53,35,56,40,57,52,58,EPL,
  FIL,50,-1,60,-1,68,1,78,5,84,10,89,16,91,20,92,26,
  92,32,82,32,82,24,81,19,76,14,73,11,66,7,57,4,
  50,4,43,4,32,6,25,11,20,15,17,22,17,33,7,33,
  7,25,8,20,11,15,18,7,25,3,35,0,40,-1,52,-1,EPL,EOD};
static int CH50[] = { /* P */
  FIL,11,56,53,56,64,56,71,54,76,53,80,51,85,47,88,43,
  89,39,88,35,85,31,82,28,76,25,66,23,54,22,44,22,
  32,22,32,27,42,27,62,27,71,29,76,32,78,35,79,39,
  78,43,76,46,70,49,63,51,57,51,11,51,11,56,EPL,
  FIL,34,52,34,5,58,5,58,0,11,0,11,5,25,5,25,52,
  34,52,EPL,EOD};
static int CH51[] = { /* Q */
  FIL,20,16,13,13,9,19,7,25,7,31,10,41,17,48,24,53,
  33,56,40,57,50,58,59,57,67,56,74,53,81,49,87,44,
  90,38,92,30,92,24,89,16,80,18,83,23,83,32,80,38,
  76,44,69,49,60,52,53,52,45,52,36,51,26,46,20,41,
  17,34,17,24,18,19,20,16,EPL,
  FIL,82,19,90,16,87,12,78,5,69,1,59,-1,52,-2,48,-2,
  44,-4,52,-4,59,-5,66,-7,71,-8,76,-7,82,-6,86,-5,
  91,-9,80,-13,74,-13,66,-12,59,-10,50,-9,46,-9,40,-9,
  34,-10,27,-13,24,-9,37,-1,36,0,25,3,18,8,14,11,
  11,16,18,18,24,12,27,10,33,6,40,5,46,4,55,4,
  64,5,70,8,75,12,80,17,81,19,EPL,EOD};
static int CH52[] = { /* R */
  FIL,8,56,54,56,63,56,68,55,73,53,78,50,82,45,83,40,
  81,36,76,31,68,29,57,27,21,27,21,31,58,31,65,33,
  71,36,73,39,73,43,70,48,67,50,61,51,8,51,8,56,EPL,
  FIL,30,52,30,6,44,6,44,1,7,1,7,6,21,6,21,52,
  30,52,EPL,
  FIL,57,27,63,23,70,16,81,6,96,6,96,1,74,1,69,7,
  63,14,55,21,50,25,46,27,58,27,EPL,EOD};
static int CH53[] = { /* S */
  FIL,84,57,83,48,84,38,76,38,75,42,71,47,68,49,64,51,
  58,52,50,53,40,52,36,51,31,48,26,44,25,40,27,37,
  31,34,36,32,44,31,51,30,56,30,55,25,46,26,39,27,
  31,29,25,30,21,32,17,36,17,41,18,46,22,51,29,54,
  37,56,45,58,52,58,59,57,65,55,74,52,75,53,76,57,
  83,57,EPL,
  FIL,17,-1,18,8,16,18,24,19,25,13,29,9,33,7,38,5,
  43,4,52,4,61,4,66,5,71,8,75,12,76,16,75,19,
  71,22,66,24,57,25,50,26,45,27,46,31,55,30,62,30,
  71,29,76,27,80,24,84,20,85,15,83,10,79,5,72,2,
  64,0,56,-1,49,-1,42,-1,36,1,27,4,26,3,24,-1,
  18,-1,EPL,EOD};
static int CH54[] = { /* T */
  FIL,54,51,54,5,74,5,74,0,26,0,26,5,46,5,46,51,
  18,51,16,31,7,32,10,56,90,56,94,33,84,31,82,51,
  55,51,EPL,EOD};
static int CH55[] = { /* U */
  FIL,84,51,84,22,83,15,81,9,75,4,64,0,55,-1,49,-1,
  38,-1,27,3,20,7,17,14,16,18,16,51,4,51,4,56,
  41,56,41,51,24,51,24,20,26,13,31,7,38,5,49,4,
  60,4,68,6,71,9,74,13,75,18,75,51,59,51,59,56,
  96,56,96,51,85,51,EPL,EOD};
static int CH56[] = { /* V */
  FIL,89,50,56,-1,45,-1,13,51,1,51,1,56,37,56,37,51,
  22,51,51,5,80,50,64,50,64,56,99,56,99,50,89,50,EPL,EOD};
static int CH57[] = { /* W */
  FIL,93,51,80,0,70,0,50,36,30,0,20,0,9,51,1,51,
  1,56,34,56,34,51,17,51,26,11,48,46,54,46,75,10,
  85,51,67,51,67,56,99,56,99,51,93,51,EPL,EOD};
static int CH58[] = { /* X */
  FIL,92,56,92,52,84,52,56,30,86,5,96,5,96,0,61,0,
  61,5,75,5,51,26,25,5,42,5,42,0,6,0,6,5,
  16,5,46,29,19,51,9,51,9,56,42,56,42,51,29,51,
  51,33,73,51,61,51,61,56,92,56,EPL,EOD};
static int CH59[] = { /* Y */
  FIL,96,57,96,51,84,51,55,23,55,5,75,5,75,0,26,0,
  26,5,46,5,46,22,17,51,6,51,6,57,38,57,38,51,
  27,51,51,27,75,51,62,51,62,57,95,57,EPL,EOD};
static int CH5A[] = { /* Z */
  FIL,83,56,83,52,25,5,79,5,79,21,87,21,87,1,14,1,
  14,5,71,51,24,51,24,37,16,37,16,57,83,57,EPL,EOD};
static int CH5B[] = { /* bracketleft */
  FIL,60,60,60,-4,81,-4,81,-9,52,-9,52,65,81,65,81,60,
  60,60,EPL,EOD};
static int CH5C[] = { /* backslash */
  FIL,23,70,86,-12,79,-14,16,69,23,70,EPL,EOD};
static int CH5D[] = { /* bracketright */
  FIL,40,60,40,-4,19,-4,19,-9,48,-9,48,65,19,65,19,60,
  40,60,EPL,EOD};
static int CH5E[] = { /* asciicricum */
  FIL,50,50,23,16,12,16,44,56,57,56,88,16,77,16,51,50,EPL,EOD};
static int CH5F[] = { /* underscore */
  FIL,-8,-8,109,-8,109,-13,-8,-13,-8,-8,EPL,EOD};
static int CH60[] = { /* grave */
  FIL,60,56,47,32,30,32,48,56,59,56,EPL,EOD};
static int CH61[] = { /* a */
  FIL,92,0,92,5,78,5,78,31,76,36,72,41,65,43,54,45,42,45,31,44,
  17,41,20,36,31,39,42,40,51,41,61,39,66,37,69,33,69,0,92,0,EPL,
  FIL,71,16,60,9,50,5,41,4,32,4,26,5,23,7,20,10,19,15,24,19,31,22,
  39,23,49,24,61,23,71,22,74,26,54,28,38,28,28,26,19,23,13,20,
  11,16,11,10,14,6,20,2,30,-1,44,-1,54,1,64,5,75,11,71,16,EPL,EOD};
static int CH62[] = { /* b */
  FIL,2,62,24,63,24,0,3,0,3,5,17,4,17,58,1,57,2,62,EPL,
  FIL,24,34,29,37,37,41,46,43,56,43,68,42,78,38,85,34,89,28,91,21,90,15,85,9,
  78,4,70,1,60,-1,47,-1,33,3,24,8,24,20,27,16,30,11,38,7,47,5,59,4,68,6,76,10,
  81,16,82,21,79,29,74,34,64,37,54,39,46,38,37,35,28,29,24,23,24,34,EPL,EOD};
static int CH63[] = { /* c */
  FIL,88,44,86,28,78,27,76,32,74,35,68,37,60,39,47,39,
  41,39,33,36,28,33,25,30,22,24,22,18,25,13,30,9,
  36,6,44,4,54,4,64,5,72,7,87,12,92,9,81,4,
  66,0,56,-1,49,-1,39,0,31,2,22,6,15,12,12,20,
  13,26,16,31,18,34,25,39,34,42,43,44,52,45,62,44,
  70,42,78,39,80,44,88,44,EPL,EOD};
static int CH64[] = { /* d */
  FIL,84,62,84,5,98,5,98,0,75,0,75,8,70,5,66,3,
  61,7,68,11,72,15,74,19,75,24,71,30,66,33,71,37,
  75,34,75,57,48,56,48,61,84,62,EPL,
  FIL,64,8,69,4,63,2,58,0,51,-1,43,-1,33,0,24,3,
  16,9,11,14,10,18,9,23,11,29,16,33,20,37,28,40,
  35,42,46,43,56,42,65,40,72,36,67,33,61,35,55,37,
  48,38,41,38,36,37,32,35,25,32,20,29,19,23,19,18,
  22,13,27,9,32,7,37,5,46,4,53,5,58,6,64,8,EPL,EOD};
static int CH65[] = { /* e */
  FIL,22,25,81,25,78,31,73,36,64,39,56,40,49,40,42,39,
  35,37,30,34,26,31,22,27,15,29,18,34,23,38,30,41,
  36,43,43,44,53,45,62,44,70,42,77,40,81,37,86,34,
  89,30,90,25,90,20,22,20,22,25,EPL,
  FIL,23,28,22,25,22,20,23,17,25,13,30,9,37,6,44,4,
  54,4,63,4,72,6,80,8,90,10,93,6,87,4,75,1,
  67,0,60,0,50,-1,40,0,28,3,17,10,13,17,14,25,
  16,31,23,28,EPL,EOD};
static int CH66[] = { /* f */
  FIL,43,51,43,42,78,42,78,37,43,37,43,5,78,5,78,1,
  16,1,16,5,34,5,34,37,17,37,17,42,34,42,35,51,
  35,56,38,58,40,59,45,61,50,62,56,62,65,62,77,62,
  84,61,81,56,73,57,63,57,54,57,49,57,44,54,43,51,EPL,EOD};
static int CH67[] = { /* g */
  FIL,93,43,93,38,79,38,79,0,78,-4,73,-9,68,-12,60,-13,
  54,-15,46,-15,30,-15,30,-11,51,-11,57,-9,65,-7,69,-3,
  70,0,70,43,93,43,EPL,
  FIL,72,35,63,40,55,42,47,43,36,43,28,42,20,38,14,34,
  10,29,8,22,9,17,14,10,22,5,32,2,44,1,54,2,
  62,4,72,9,72,21,68,16,63,12,59,9,51,6,44,6,
  34,8,25,12,18,18,18,25,20,29,24,32,31,36,40,38,
  49,38,56,36,61,35,65,31,69,29,70,25,72,24,72,36,EPL,EOD};
static int CH68[] = { /* h */
  FIL,29,63,29,37,37,40,43,42,49,44,56,44,61,44,68,43,
  73,41,78,38,81,34,82,31,82,5,96,5,96,0,59,0,
  59,5,73,5,73,29,72,34,69,37,62,39,54,39,47,38,
  40,36,33,33,29,32,29,5,43,5,43,0,7,0,7,5,
  21,5,21,58,4,57,4,61,29,63,EPL,EOD};
static int CH69[] = { /* i */
  FIL,55,65,55,54,43,54,43,65,55,65,EPL,
  FIL,55,43,55,5,84,5,84,0,17,0,17,5,46,5,46,38,
  22,38,22,43,55,43,EPL,EOD};
static int CH6A[] = { /* j */
  FIL,63,65,63,54,50,54,50,65,63,65,EPL,
  FIL,66,43,66,0,65,-4,62,-7,60,-10,52,-13,45,-14,38,-15,
  34,-15,24,-15,18,-14,11,-13,14,-8,20,-9,30,-10,40,-10,
  48,-9,51,-7,54,-5,56,-1,57,1,57,38,15,38,15,43,
  66,43,EPL,EOD};
static int CH6B[] = { /* k */
  FIL,31,63,31,24,62,38,53,38,53,43,88,43,88,38,74,38,
  48,26,80,5,94,5,94,1,59,1,59,5,70,5,41,23,
  31,18,31,1,10,1,10,5,23,5,23,58,7,57,7,62,
  31,63,EPL,EOD};
static int CH6C[] = { /* l */
  FIL,55,61,55,5,83,5,83,1,17,1,17,5,46,5,46,56,
  18,55,18,59,48,61,54,61,EPL,EOD};
static int CH6D[] = { /* m */
  FIL,1,43,20,43,20,40,26,43,31,44,36,44,42,44,47,42,
  52,38,57,41,65,43,72,44,80,43,85,41,88,38,90,34,
  90,5,99,5,99,0,82,0,82,32,80,36,78,38,73,39,
  68,39,64,38,60,36,56,33,56,5,66,5,66,0,47,0,
  47,32,44,36,41,39,33,39,27,37,23,35,20,34,20,5,
  31,5,31,0,1,0,1,5,12,5,12,39,1,39,1,43,EPL,EOD};
static int CH6E[] = { /* n */
  FIL,28,31,38,35,44,37,52,39,60,39,65,38,70,35,72,31,
  73,30,73,5,59,5,59,1,95,1,95,5,81,5,81,31,
  78,37,73,41,64,44,57,45,46,43,38,41,28,37,28,43,
  6,43,6,38,20,38,20,5,6,5,6,1,42,1,42,5,
  28,5,28,31,EPL,EOD};
static int CH6F[] = { /* o */
  FIL,51,45,57,45,65,44,71,42,78,40,83,37,87,34,90,30,
  92,26,92,19,83,19,83,25,80,29,78,33,72,36,66,39,
  60,40,53,40,45,40,40,39,35,39,30,36,26,34,22,32,
  19,28,19,26,19,19,9,19,9,26,11,30,13,33,17,36,
  20,38,26,41,34,43,42,45,52,45,EPL,
  FIL,51,-1,57,-1,65,0,71,2,78,4,83,7,87,10,90,14,
  92,18,92,25,83,25,83,19,80,15,78,11,72,8,66,6,
  60,4,53,4,45,4,40,5,35,6,30,8,26,10,22,12,
  19,17,19,18,19,25,9,25,9,18,11,14,13,11,17,8,
  20,6,26,3,34,1,42,-1,52,-1,EPL,EOD};
static int CH70[] = { /* p */
  FIL,4,43,25,43,25,-11,51,-11,51,-15,4,-15,4,-11,17,-11,
  17,39,4,39,4,43,EPL,
  FIL,25,26,27,29,29,31,34,35,40,37,46,39,54,40,62,39,
  67,38,72,36,78,31,81,27,82,20,80,16,77,12,72,8,
  65,6,57,4,49,5,41,7,34,9,29,13,25,18,25,8,
  31,5,37,2,45,1,51,0,58,0,65,1,72,2,79,6,
  84,9,87,12,90,17,91,20,91,26,88,31,83,36,78,40,
  68,43,59,44,48,44,41,43,38,42,31,40,25,36,25,26,EPL,EOD};
static int CH71[] = { /* q */
  FIL,96,43,75,43,75,-11,49,-11,49,-15,96,-15,96,-11,83,-11,
  83,39,96,39,96,43,EPL,
  FIL,75,26,73,29,71,31,66,35,60,37,54,39,46,40,38,39,
  33,38,28,36,22,31,19,27,18,20,20,16,23,12,28,8,
  35,6,43,4,51,5,59,7,66,9,71,13,75,18,75,8,
  69,5,63,2,55,1,49,0,42,0,35,1,28,2,21,6,
  16,9,13,12,10,17,9,20,9,26,12,31,17,36,22,40,
  32,43,41,44,52,44,59,43,62,42,69,40,75,36,75,26,EPL,EOD};
static int CH72[] = { /* r */
  FIL,15,43,42,43,42,33,49,37,56,41,62,42,67,43,71,44,
  81,44,86,43,90,42,94,39,86,35,83,37,78,39,72,39,
  67,39,62,37,52,33,42,27,42,5,73,5,73,0,13,0,
  13,5,33,5,33,39,14,39,14,43,EPL,EOD};
static int CH73[] = { /* s */
  FIL,81,44,80,39,80,34,80,30,73,29,71,32,69,34,65,37,
  57,39,51,39,43,39,37,39,33,37,30,36,27,34,26,31,
  28,29,31,26,36,25,44,25,49,24,57,24,57,19,50,19,
  43,19,35,20,28,21,22,24,19,27,17,31,17,34,20,37,
  22,40,27,42,32,43,40,44,45,44,54,44,59,43,64,42,
  69,40,71,42,73,45,80,44,EPL,
  FIL,17,15,25,15,25,13,27,10,31,7,36,6,42,4,48,4,
  55,4,60,4,66,6,71,7,75,9,75,13,72,17,68,18,
  60,19,54,19,54,24,60,24,67,23,73,22,78,20,82,18,
  84,14,84,9,81,7,78,4,73,2,69,1,64,0,56,-1,
  48,-1,41,0,35,1,28,3,27,3,23,-1,17,-1,17,2,
  17,11,17,15,EPL,EOD};
static int CH74[] = { /* t */
  FIL,38,56,38,42,78,42,78,37,38,37,38,14,39,10,41,7,
  46,4,52,4,60,4,66,5,73,6,87,9,90,5,74,1,
  65,0,58,-1,52,-1,46,0,40,1,34,4,31,7,30,10,
  29,16,29,37,18,37,18,42,29,42,29,56,37,56,EPL,EOD};
static int CH75[] = { /* u */
  FIL,80,43,80,5,93,5,93,1,71,1,71,6,67,4,63,2,
  59,1,54,0,51,-1,47,-1,42,-1,36,0,30,1,25,4,
  21,10,20,13,19,17,19,38,6,38,6,43,28,43,28,16,
  29,11,31,8,35,6,39,4,45,4,50,4,55,5,60,7,
  66,9,71,12,71,39,57,39,57,43,79,43,EPL,EOD};
static int CH76[] = { /* v */
  FIL,85,39,54,0,46,0,16,39,4,39,4,43,40,43,40,39,
  26,39,51,6,76,39,63,39,63,43,97,43,97,39,85,39,EPL,EOD};
static int CH77[] = { /* w */
  FIL,93,38,75,0,66,0,51,26,35,0,27,0,8,38,1,38,
  1,43,31,43,31,38,17,38,31,8,48,35,54,35,70,8,
  85,38,72,38,72,43,99,43,99,38,93,38,EPL,EOD};
static int CH78[] = { /* x */
  FIL,93,43,93,38,81,38,56,23,86,5,96,5,96,0,62,0,
  62,5,75,5,50,19,26,5,38,5,38,0,5,0,5,5,
  15,5,44,22,19,38,7,38,7,43,40,43,40,38,30,38,
  50,26,70,38,61,38,61,43,92,43,EPL,EOD};
static int CH79[] = { /* y */
  FIL,99,43,99,38,88,38,42,-10,57,-10,57,-15,7,-15,7,-10,
  33,-10,45,3,15,39,4,39,4,43,36,43,36,38,25,38,
  50,8,79,38,68,38,68,43,99,43,EPL,EOD};
static int CH7A[] = { /* z */
  FIL,83,43,83,39,29,5,75,5,75,14,83,14,83,1,18,1,
  18,5,71,39,28,39,28,30,19,30,19,43,83,43,EPL,EOD};
static int CH7B[] = { /* braceleft */
  FIL,77,65,77,60,71,60,65,59,62,58,59,57,59,55,59,51,
  59,48,60,45,62,41,62,35,60,32,57,30,54,28,40,28,
  40,30,43,31,48,32,51,34,53,36,53,40,52,45,50,48,
  49,53,51,58,54,61,57,63,64,64,70,65,77,65,EPL,
  FIL,77,-9,77,-4,71,-4,65,-3,62,-2,59,0,59,1,59,6,
  59,8,60,12,62,15,62,21,60,24,57,26,53,28,40,28,
  40,26,43,25,48,24,51,23,53,20,53,16,52,12,50,8,
  49,3,51,-2,54,-5,57,-7,64,-8,70,-9,77,-9,EPL,EOD};
static int CH7C[] = { /* bar */
  FIL,55,67,55,-18,46,-18,46,67,55,67,EPL,EOD};
static int CH7D[] = { /* braceright */
  FIL,23,65,23,60,29,60,35,59,38,58,41,57,41,55,41,51,
  41,48,40,45,38,41,38,35,40,32,43,30,46,28,60,28,
  60,30,57,31,52,32,49,34,47,36,47,40,48,45,50,48,
  51,53,49,58,46,61,43,63,36,64,30,65,23,65,EPL,
  FIL,23,-9,23,-4,29,-4,35,-3,38,-2,41,0,41,1,41,6,
  41,8,40,12,38,15,38,21,40,24,43,26,47,28,60,28,
  60,26,57,25,52,24,49,23,47,20,47,16,48,12,50,8,
  51,3,49,-2,46,-5,43,-7,36,-8,30,-9,23,-9,EPL,EOD};
static int CH7E[] = { /* asciitilde */
  FIL,86,35,81,31,77,28,72,26,67,25,62,26,55,27,47,29,
  38,31,33,31,27,29,23,25,20,23,15,27,19,31,25,35,
  31,37,37,37,43,36,52,34,62,31,67,31,70,32,75,34,
  80,39,86,35,EPL,EOD};
static int CH7F[] = { /* nothing */
  MOV, 0, 0, EOD};

static int *GPMFont[] = {
  CH20, CH21, CH22, CH23, CH24, CH25, CH26, CH27, /* SP ! " # $ % & ' */
  CH28, CH29, CH2A, CH2B, CH2C, CH2D, CH2E, CH2F, /*  ( ) * + , - . / */
  CH30, CH31, CH32, CH33, CH34, CH35, CH36, CH37, /*  0 1 2 3 4 5 6 7 */ 
  CH38, CH39, CH3A, CH3B, CH3C, CH3D, CH3E, CH3F, /*  8 9 : ; < = > ? */
  CH40, CH41, CH42, CH43, CH44, CH45, CH46, CH47, /*  @ A B C D E F G */
  CH48, CH49, CH4A, CH4B, CH4C, CH4D, CH4E, CH4F, /*  H I J K L M N O */
  CH50, CH51, CH52, CH53, CH54, CH55, CH56, CH57, /*  P Q R S T U V W */
  CH58, CH59, CH5A, CH5B, CH5C, CH5D, CH5E, CH5F, /*  X Y Z [ \ ] ^ _ */
  CH60, CH61, CH62, CH63, CH64, CH65, CH66, CH67, /*  ` a b c d e f g */
  CH68, CH69, CH6A, CH6B, CH6C, CH6D, CH6E, CH6F, /*  h i j k l m n o */
  CH70, CH71, CH72, CH73, CH74, CH75, CH76, CH77, /*  p q r s t u v w */
  CH78, CH79, CH7A, CH7B, CH7C, CH7D, CH7E, CH7F};/*  x y z { | } ~   */

#ifdef __cplusplus
}
#endif

#endif /* GPMCMD_C_SOURCE */
#endif /* LIBGPM_FONT_H */
