/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/wopen.cpp,v 1.9 2004/09/09 10:45:13 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_DIRENT_H
# include <dirent.h>
#endif
#ifdef HAVE_DIRECT_H
# include <direct.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_wopen(){
  int     argc, num, wnum;
  char   *size, paper, orient, device, *dvifile;
  double  x, y, tmp, width, height;
  char    tmpbuf[GPM_ENV_MAX_FILEPATH], dvifilepath[GPM_ENV_MAX_FILEPATH];

  x = 0.0;
  y = 0.0;
  dvifile = NULL;
  paper = GPM_PAPER_A4;
  dvifilepath[0]='\0';

  argc   = GetArgNum();
  wnum   = (int)GetScalar(0);
  size   = GetString(1);
  orient = (char)GetScalar(2);
  device = (char)GetScalar(3);

  switch(argc){
  case 5:
    dvifile = GetString(4);
    if(dvifile == NULL)
      return 3; /* illegal parameter */
    break;
  case 6:
    x = GetScalar(4);
    y = GetScalar(5);
    break;
  }

  /* paper size check */
  if(size == NULL)
    return 3; /* illegal parameter */
  if(strcmp(size, "A4") == 0){
    paper = GPM_PAPER_A4;
  }else if(strcmp(size, "B4") == 0){
    paper = GPM_PAPER_B4;
  }else if(strcmp(size, "Free") == 0 || strcmp(size, "FREE") == 0){
    paper = GPM_PAPER_FREE;
  }else{
    return 3; /* illegal parameter */
  }
  /* window number check */
  if(wnum <= 0 || wnum > GPM_ENV_MAX_WIN)
    return 3; /* illegal parameter */
  /* orientation check */
  if(orient < GPM_ORIENT_PORTRAIT || orient > GPM_ORIENT_LANDSCAPE)
    return 3; /* illegal parameter */
  /* output device check */
  if(device <= GPM_DEVICE_NONE || device > GPM_DEVICE_FILE)
    return 3; /* illegal parameter */

  /* calculate paper width & height */
  switch(paper){
  case GPM_PAPER_A4:
    width  = GPM_PAPER_A4_WIDTH;
    height = GPM_PAPER_A4_HEIGHT;
    break;
  case GPM_PAPER_B4:
    width  = GPM_PAPER_B4_WIDTH;
    height = GPM_PAPER_B4_HEIGHT;
    break;
  case GPM_PAPER_FREE:
  default:
    width  = (x > 0.0) ? x : 150.0;
    height = (x > 0.0) ? y : 150.0;
  }
  if(orient == GPM_ORIENT_LANDSCAPE){
    tmp = width; width = height; height = tmp;
  }

  /* set device parameter */
  num = wnum - 1;
  /* change gpm context */
  chgpm(num);

  /* display waning message */
  if(GpmCont.device != GPM_DEVICE_NONE){
    printf("Window %d is already exist\n", wnum);
  }

  /* set dvifname name */
  if(device == GPM_DEVICE_DISPFILE || device == GPM_DEVICE_FILE){
    if(getcwd(tmpbuf, GPM_ENV_MAX_FILEPATH) == NULL)
      return 2;  /* out of memory */
#ifdef WIN32
    {
      char *p;
      for(p = tmpbuf; *p!=0; p++)
        if(*p == '\\') *p = '/';
    }
#endif
    if(dvifile == 0 || *dvifile == '\0'){
      snprintf(dvifilepath, GPM_ENV_MAX_FILEPATH, "%s/%s%d", 
               tmpbuf, GPM_DVIFILE_BASENAME, wnum);
    }else{
      snprintf(dvifilepath, GPM_ENV_MAX_FILEPATH, "%s/%s", 
               tmpbuf, dvifile);
    }
  }

  /* open device */
  /*  dvifile */
  if(device == GPM_DEVICE_FILE || device == GPM_DEVICE_DISPFILE){
    if(libgpm_dvi_create(dvifilepath, paper, orient, device) != 0)
      return 1; /* TODO: assignment errono: */
  }
  /*  window */
  if(device == GPM_DEVICE_DISPLAY || device == GPM_DEVICE_DISPFILE){
    if(libgpm_window_create(wnum, paper, orient, width, height) != 0)
      return 1; /* TODO: assignment errono: */
  }

  GpmCont.winNum      = num;
  GpmCont.paper       = paper;
  GpmCont.paperWidth  = (float)width;
  GpmCont.paperHeight = (float)height;
  GpmCont.orientation = orient;
  GpmCont.device      = device;
  strcpy(GpmCont.dvifile, dvifilepath); /* safe */

  /* save modified parameters */
  wrgpm();

  return 0;
}

#ifdef __cplusplus
}
#endif

