/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/title.cpp,v 1.3 2005/02/02 18:08:36 orrisroot Exp $ */

/***********************************************
 *                                              *
 *      SET TITLE                               *
 *                                              *
 *    Original coded by T.KOBAYASHI  07/12/1989 *
 *                                              *
 ***********************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#define ONE_LINE 512

#ifdef __cplusplus
extern "C" {
#endif


DLLEXPORT int mod_gpm_title(){
  char  *ialpha[3];
  int   i, j, k, num, ib, iflags, narg;
  char  in[GPM_ENV_MAX_TITLELEN+1], cl[ONE_LINE];
  char  cls[GPM_ENV_MAX_TITLELEN+1], *title[3];
  static char  dc[3] = {'X', 'Y', 'Z'};
  
  regpm();
  
  ib = (int)GetScalar(0) -1;
  if(ib < 0 || ib >= GPM_ENV_MAX_TITLE)
    return 3; /* illegal parameter */
  iflags = 0;
  for(i=1; i < 4; i++)
    ialpha[i-1] = GetString(i);

  title[0] = GpmCont.title_x[ib];
  title[1] = GpmCont.title_y[ib];
  title[2] = GpmCont.title_z[ib];

  narg = GetArgNum();
  if(narg >= 4 && strcmp(GetArgType(3),"string") == 0 )
    strcpy(title[2],ialpha[2]);

  num = (narg == 3 ) ? 2 : 3;
  for(k=0; k < num; k++){
    if(ialpha[k] == NULL || strlen(ialpha[k]) == 0){
      strncpy(in, title[k], GPM_ENV_MAX_TITLELEN);
      in[GPM_ENV_MAX_TITLELEN] = EOS;
      printf("\nTITLE(%d) %c - AXIS \"%s\"\n", ib+1, dc[k], in);
      printf("                   ");
      for(i = 0; i < ONE_LINE; cl[i++] = 0x00);
      if(sl4_getstr(cl, ONE_LINE-1) == NULL){
        return 99;
      }
      if(cl[0] != EOS){
        for(i=0; i < GPM_ENV_MAX_TITLELEN; i++){
          if(cl[i] < 0x20){
            j = i;
            while(j < GPM_ENV_MAX_TITLELEN)
              cl[j++] = 0x00;
            break;
          }
        }
      }else{
        iflags = 1;
      }
      strncpy(cls, cl, GPM_ENV_MAX_TITLELEN);
    }else{
      strncpy(cls, ialpha[k], GPM_ENV_MAX_TITLELEN);
    }

    if(iflags != 1){
      if( strlen(cls) == 0 || ( strlen(cls) == 1 && cls[0] == ' ' ))
        title[k][0] = '\0';
      else
        strcpy(title[k], cls);
    }
  }
  
  wrgpm();
  return 0;
}

#ifdef __cplusplus
}
#endif

