/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/prev.cpp,v 1.11 2005/02/02 18:08:36 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_prev(){
  int   num;
  int   result;
  int   div     = GPM_RAINBOW_DIVNUM;
  int   basecol = GPM_RAINBOW_BASECOL;
  int   lwidth, ltype, lcolor, lrainbow, lmode;
  static int   preColor=-1, preRainbow=0, preType=-1, preWidth=-1; 
  int   rollflag = 0;
  int   pages = 1;
  char  *gpm_dvifile;
  
  regpm();

  if(GetArgNum() != 0){
    gpm_dvifile = GetString(0);
    strcpy(GpmCont.dvifile, gpm_dvifile);
  }else{
    strcpy(GpmCont.dvifile, "GPMDVIFILE1");
    gpm_dvifile = GpmCont.dvifile;
  }

  if(libgpm_dvi_open(&gpmdev_cont.dvi, GpmCont.dvifile, 1) == -1){
    return 3; /* can't open GPMDVI file */
  }
  if(libgpm_dvi_read_head(&gpmdev_cont.dvi, &GpmCont.paper,
                          &GpmCont.orientation, &GpmCont.device) == -1){
    return 17; /* file is not GPMDVI file */
  }
  gpmdev_cont.common.paper       = GpmCont.paper;
  gpmdev_cont.common.orientation = GpmCont.orientation;
  gpmdev_cont.common.device      = GpmCont.device;

  printf("Preview of %s\n", gpm_dvifile);
  
  GpmCont.device = 0;

  if(gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device,
           GpmCont.paperWidth, GpmCont.paperHeight) != 0){
    libgpm_dvi_close(&gpmdev_cont.dvi);
    return 6; /* window does not exist */
  }
  gerase();
  
  printf("Page %2d: ", pages);

  do {
    result = libgpm_dvi_read_param(&gpmdev_cont.dvi);
    if(result > 0){
      if(rollflag == 1){
        char buf[32];
        printf(" press return >> next page.");
        if(sl4_getstr(buf, 32) == NULL){
          libgpm_dvi_close(&gpmdev_cont.dvi);
          gflush();
          gclose();
          return 99;
        }
        gerase();
        printf("Page %2d: ",++pages);
        rollflag = 0;
      }
      
      gfactor((double)gpmdev_cont.dvi.param.factor);
      gorigin((double)gpmdev_cont.dvi.param.xorg, 
              (double)gpmdev_cont.dvi.param.yorg);

      do {

        num = libgpm_dvi_read_element(&gpmdev_cont.dvi);

        if(num > 0){
          switch(num){
          case GPM_DVIFILE_ELEMENT_PLOT:
            lwidth = (int)gpmdev_cont.dvi.plot.lwidth;
            ltype  = (int)gpmdev_cont.dvi.plot.ltype;
            lcolor = (int)gpmdev_cont.dvi.plot.color;
            lrainbow = (int)gpmdev_cont.dvi.plot.rainbow;
            lmode  = (int)gpmdev_cont.dvi.plot.ipen_mode;
            if(preWidth != lwidth || preType != ltype){
              gpen(lwidth, ltype, 0);
              preWidth = lwidth;
              preType  = ltype;
            }
            if(preColor != lcolor || preRainbow != lrainbow){
              if(lcolor != -1)
                gnewpen(lcolor);
              else
                grainbow(((float)lrainbow/(float)(div*basecol)));
              preColor = lcolor;
              preRainbow = lrainbow;
            }
            gplot(gpmdev_cont.dvi.plot.x, gpmdev_cont.dvi.plot.y, lmode);
            break;
            
          case GPM_DVIFILE_ELEMENT_BOX:
            lwidth = (int)gpmdev_cont.dvi.box.lwidth;
            ltype  = (int)gpmdev_cont.dvi.box.ltype;
            lcolor = (int)gpmdev_cont.dvi.box.color;
            lmode  = (int)gpmdev_cont.dvi.box.mode;

            gpen(lwidth, ltype, 0);
            if(lcolor == -1 && gpmdev_cont.dvi.box.level >= 0.0)
              grainbow(gpmdev_cont.dvi.box.level);
            else
              gnewpen(lcolor);

            gbox(gpmdev_cont.dvi.box.x1, gpmdev_cont.dvi.box.y1, 
                 gpmdev_cont.dvi.box.x2, gpmdev_cont.dvi.box.y2,
                 gpmdev_cont.dvi.box.mode, gpmdev_cont.dvi.box.level);
            break;
            
          case GPM_DVIFILE_ELEMENT_CSYMBOL:
            lcolor = (int)gpmdev_cont.dvi.csymbol.color;
            gnewpen(lcolor);
            
            gpmdev_cont.symbol.theta  = gpmdev_cont.dvi.csymbol.theta;
            gcsize(gpmdev_cont.dvi.csymbol.height);
            gsymbol(gpmdev_cont.dvi.csymbol.x, gpmdev_cont.dvi.csymbol.y, 
                    gpmdev_cont.dvi.csymbol.cdata);
            break;
            
          case GPM_DVIFILE_ELEMENT_LABEL:
            lcolor = (int)gpmdev_cont.dvi.label.color;
            gnewpen(lcolor);
            
            glabel(gpmdev_cont.dvi.label.x, gpmdev_cont.dvi.label.y, 
                   gpmdev_cont.dvi.label.ichar, gpmdev_cont.dvi.label.height,
                   gpmdev_cont.dvi.label.theta, gpmdev_cont.dvi.label.mode,
                   NULL);
            break;

          case GPM_DVIFILE_ELEMENT_ROLL:
            printf("done. ");
            rollflag = 1;
            break;
          }
        }
      } while (num > 0);
    }
  } while (result > 0);
  
  libgpm_dvi_close(&gpmdev_cont.dvi);
  printf("done.\n");

  gflush();
  gclose();

  return 0;
}

#ifdef __cplusplus
}
#endif
