/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/lwidth.cpp,v 1.2 2004/06/23 08:32:21 orrisroot Exp $ */

/************************************************
*              SET LINE WIDTH                   *
*                                               *
*   lwidth(I1, I2)                              *
*                                               *
*     I1   : GRAPH LINE WIDTH  ( 1 .. 3 )       *
*     I2   : AXIS & FRAME LINE WIDTH            *
*                                               *
*     original coded by T.KOBAYASHI /12/03/1988 *
*                                               *
************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_lwidth(){
  int numer[2], i;
  /* LOAD SYSTEM PARAMETER */
  regpm();

  numer[0] = (int)GetScalar(0)-1;
  numer[1] = (int)GetScalar(1)-1;
  
  for(i=0; i <= 1; i++)
    if(numer[i] < 0 || numer[i] > 4)
      return 3; /* illegal parameter */
  
  GpmCont.gLineWidth = numer[0];
  GpmCont.fLineWidth = numer[1];
  
  wrgpm();
  return 0;
}

#ifdef __cplusplus
}
#endif
