/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/line.cpp,v 1.6 2004/09/09 10:45:13 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_line(){
  float rnumer[4];
  char  *ialpha;

  /* LOAD SYSTEM PARAMETER */
  regpm();

  rnumer[0] = (float)GetScalar(0);
  rnumer[1] = (float)GetScalar(1);
  rnumer[2] = (float)GetScalar(2);
  rnumer[3] = (float)GetScalar(3);
  ialpha    =        GetString(4);

  /* LINE DRAW */
  if(gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, 
           GpmCont.paperWidth, GpmCont.paperHeight) != 0)
    return 6; /* window does not exist */
  if(checktodvi() != 0)
    libgpm_dvi_write_param(&gpmdev_cont.dvi, GpmCont.factor, 
                           GpmCont.xOrigin, GpmCont.yOrigin);
  gnewpen(GpmCont.gColor);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);

  if(ialpha != NULL && strlen(ialpha) > 0 && ialpha[0] == 'B'){
    if(strlen(ialpha) > 1 && ialpha[1] == 'F')
      gbox(rnumer[0], rnumer[1], rnumer[2], rnumer[3], 3, 0.);
    else
      gbox(rnumer[0], rnumer[1], rnumer[2], rnumer[3], 1, 0.);
  }else{
    gplot(rnumer[0], rnumer[1], 0);
    gplot(rnumer[2], rnumer[3], 2);
  }
  gflush();
  gclose();
  wrgpm();
  return 0;
}
#ifdef __cplusplus
}
#endif
