/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/interval.cpp,v 1.1 2004/07/27 12:33:21 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_SYS_TIMEB_H
# include <sys/timeb.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_GETTIMEOFDAY

static struct timeval  tp;
static struct timezone tzp;
static unsigned long   tv_sec;
static long            tv_usec;
static unsigned long   ntime;
static long            nusec;

void gpmcmd_interval_store_start_time(){
  gettimeofday(&tp, &tzp);
  tv_sec  = tp.tv_sec;
  tv_usec = tp.tv_usec;
}

void gpmcmd_interval_wait_msec(int waittime){
  waittime *= 1000;
#ifdef HAVE_USLEEP
  gettimeofday(&tp, &tzp);
  ntime = tp.tv_sec-tv_sec;
  nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  waittime -= (int)nusec;
  if(waittime > 0)
    usleep(waittime);
#else
  do {
    gettimeofday(&tp, &tzp);
    ntime = tp.tv_sec-tv_sec;
    nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  }while(nusec < (long)waittime);
#endif
}

void gpmcmd_interval_wait_msec2(int waittime){
  waittime *= 1000;
#ifdef HAVE_USLEEP
  usleep(waittime);
#else
  gettimeofday(&tp, &tzp);
  tv_sec  = tp.tv_sec;
  tv_usec = tp.tv_usec;
  do {
    gettimeofday(&tp, &tzp);
    ntime = tp.tv_sec-tv_sec;
    nusec = (long)(ntime*1000000+tp.tv_usec-tv_usec);
  } while (nusec < (long)waittime);
#endif

}

#else /* HAVE_GETTIMEOFDAY */

static struct timeb tp;
static long btime;
static unsigned short bmilisec;
static long ntime;
static long nmilisec;

void gpmcmd_interval_store_start_time(){
  ftime(&tp);
  btime=(long)tp.time;
  bmilisec=tp.millitm;
}

void gpmcmd_interval_wait_msec(int waittime){
#if defined(HAVE_USLEEP) || defined(HAVE_WINDOWS_H)
    ftime(&tp);
    ntime = (long)(tp.time-btime);
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
    waittime -= (int)nmilisec;
    if(waittime > 0){
# ifdef HAVE_WINDOWS_H
      Sleep(waittime);
# else
      usleep(waittime*1000);
# endif
    }
# else
  do {
    ftime(&tp);
    ntime = (long)(tp.time-btime);
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
  } while (nmilisec < (long)waittime);
#endif
}

void gpmcmd_interval_wait_msec2(int waittime){
#ifdef HAVE_WINDOWS_H
  Sleep(waittime);
#else
# ifdef HAVE_USLEEP
  usleep(waittime*1000);
# else
  ftime(&tp);
  btime=(long)tp.time;
  bmilisec=tp.millitm;
  do {
    ftime(&tp);
    ntime = (long)(tp.time-btime);
    nmilisec = (long)(ntime*1000+tp.millitm-bmilisec);
  } while (nmilisec < (long)waittime);
# endif
#endif
}

#endif /* HAVE_GETTIMEOF_DAY */

#ifdef __cplusplus
}
#endif

