/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/gstat.cpp,v 1.2 2004/07/03 17:58:54 orrisroot Exp $ */

/*********************************************
*          PRINT GPM STATUS                  *
*                                            *
*    Original coded by Y.Miyamoto (03/13/91) *
*********************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#define FONT_MAX 12

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_gstat(){
  int          i;
  static char *fonttype[FONT_MAX] = {
    "Times Roman", "Times Italic", "Times Bold", "Times Bold Italic",
    "Helvetica", "Helvetica Oblique", "Helvetica Bold",
    "Helvetica Bold Oblique",
    "Courier", "Courier Oblique", "Courier Bold", "Courier Bold Oblique"};

  /************** read parameter **************/
  regpm();
  
  for(i=0; i < GPM_ENV_MAX_TITLE; i++){
    GpmCont.title_x[i][GPM_ENV_MAX_TITLELEN-1] = '\0';
    GpmCont.title_y[i][GPM_ENV_MAX_TITLELEN-1] = '\0';
    GpmCont.title_z[i][GPM_ENV_MAX_TITLELEN-1] = '\0';
  }
  
  printf("-------------------------------------\n");
  printf("GPM COMMON PARAMETERS\n");
  printf("Current Window = No. %d\n", GpmCont.winNum+1);
  if(GpmCont.device == GPM_DEVICE_NONE)
    printf("No device opend\n");

  printf("-------------------------------------\n");
  printf("Paper Size: ");
  switch(GpmCont.paper){
  case 0: printf("A4"); break;
  case 1: printf("B4"); break;
  default:
    printf("Free Size(%.2fmm x %.2fmm)",
           GpmCont.paperWidth, GpmCont.paperHeight);
    break;
  }    
  printf(", Orientation: ");
  if(GpmCont.orientation == 0)
    printf("0(Portrait)\n");
  else
    printf("1(Landscape)\n");
  
  if(GpmCont.device == 0) 
    printf ("No DVIFILE\n");
  else
    printf ("DVIFILEPATH = \"%s\"\n", GpmCont.dvifile);
  printf("-------------------------------------\n");
  printf("Factor    : %.4f\n", GpmCont.factor);
  printf("Origin    : (%.2f mm, %.2f mm)\n",
         GpmCont.xOrigin, GpmCont.yOrigin);
  printf("Size      : (%.2f mm, %.2f mm)\n",
         GpmCont.xSize, GpmCont.ySize);
  printf("Font Type : %d (%s)\n",
         GpmCont.fontType+1, fonttype[(int)GpmCont.fontType]);
  printf("Frame Line: Width %d, Type %d, Color %d\n",
         GpmCont.fLineWidth+1, GpmCont.fLineType+1, GpmCont.fColor);
  printf("Graph Line: Width %d, Type %d, Color %d\n",
         GpmCont.gLineWidth+1, GpmCont.gLineType+1, GpmCont.gColor);
  printf("Scale type: X=%d, Y=%d, Z=%d (0:Normal 1:Log)\n",
         GpmCont.xType, GpmCont.yType, GpmCont.zType);
  printf("Scale mode: X=%d, Y=%d, Z=%d (0:Auto 1:Fixed 2:Default)\n",
         GpmCont.xMode, GpmCont.yMode, GpmCont.zMode);
  printf("Scale X = min:%g, max:%g\n",
         GpmCont.xMin, GpmCont.xMax);
  printf("Scale Y = min:%g, max:%g\n",
         GpmCont.yMin, GpmCont.yMax);
  printf("Scale Z = min:%g, max:%g\n",
         GpmCont.zMin, GpmCont.zMax);

  for(i=0; i < GPM_ENV_MAX_TITLE; i++){
    printf("TITLE %d:\n", i+1);
    printf("  X: \"%s\"\n", GpmCont.title_x[i]);
    printf("  Y: \"%s\"\n", GpmCont.title_y[i]);
    printf("  Z: \"%s\"\n", GpmCont.title_z[i]);
  }
  printf("-------------------------------------\n");

  return 0;
}

#ifdef __cplusplus
}
#endif

