/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/ginit.cpp,v 1.2 2004/08/02 11:25:12 orrisroot Exp $ */

/******************************************************
 *                                                    *
 *    INITIALIZE GRAPHIC PARAMETER                    *
 *                                                    *
 *      oritinal coded by T.Kobayashi (06/29/89)      *
 *                     by Y.Miyamoto  (03/13/91)      *
 *****************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_ginit(){
  int             i, j;
  regpm();
  
  GpmCont.factor       = 1.0;
  GpmCont.xOrigin      = 20.0;
  GpmCont.yOrigin      = 20.0;
  GpmCont.xSize        = 100.0;
  GpmCont.ySize        = 100.0;
  GpmCont.fontType     = GPM_FONT_TYPE_TR;      /* times roman */
  GpmCont.fLineWidth   = 0;
  GpmCont.gLineWidth   = 0;
  GpmCont.fLineType    = GPM_LINE_TYPE_SOLID;   /* solid */
  GpmCont.gLineType    = GPM_LINE_TYPE_SOLID;   /* solid */
  GpmCont.fColor       = GPM_COLOR_BLACK;       /* black */
  GpmCont.gColor       = GPM_COLOR_BLACK;       /* black */

  GpmCont.axisType     = GPM_AXIS_TYPE_RR;      /* real and real */
  GpmCont.axisDraw     = GPM_AXIS_DRAW_LB;      /* integer and real */

  GpmCont.xType        = GPM_SCALE_TYPE_LINEAR; /* linear */
  GpmCont.yType        = GPM_SCALE_TYPE_LINEAR; /* linear */
  GpmCont.zType        = GPM_SCALE_TYPE_LINEAR; /* linear */

  GpmCont.xMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  GpmCont.yMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  GpmCont.zMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  
  GpmCont.xMin         = 0.0;
  GpmCont.xMax         = 1.0;
  GpmCont.yMin         = 0.0;
  GpmCont.yMax         = 1.0;
  GpmCont.zMin         = 0.0;
  GpmCont.zMax         = 1.0;
  
  for (i = 0; i < GPM_ENV_MAX_TITLE; i++) {
    for (j = 0; j < GPM_ENV_MAX_TITLELEN; j++) {
      GpmCont.title_x[i][j] = ' ';
      GpmCont.title_y[i][j] = ' ';
      GpmCont.title_z[i][j] = ' ';
    }
    GpmCont.title_x[i][0] = '\0';
    GpmCont.title_y[i][0] = '\0';
    GpmCont.title_z[i][0] = '\0';
  }
  
  wrgpm();
  return 0;
}

#ifdef __cplusplus
}
#endif

