/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/cont.cpp,v 1.7 2004/09/09 10:45:13 orrisroot Exp $ */

/*****************************************************
*                                                    *
*   DRAW CONTOUR LINE     New Parameter              *
*                                                    *
*   C Version  Rel 1.0    T.Kobayashi  90/08/31      *
*   Buffer Version        T.Kobayashi  90/08/31      *
*   on SATELLITE Language S.Hitomi     92/11/17      *
*                                                    *
*****************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"
#include "cont_sub.h"
#include "ldata.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_cont(){
  float **data, heit[500];
  int   **data2;
  double step, zMax, zMin;
  int   index[MAX_INDEX];
  int   bufno, i, j, kh, viewpoint, nx, ny, mode;
  char  *timeaxis;
  double rmin, rmax, hx, hy;
  
  /* LOAD SYSTEM PARAMETER */
  regpm();
  
  /* this command needs 5 parameters */
  bufno     = GetBufferID(0);
  step      = GetScalar(1);
  timeaxis  = GetString(2);
  viewpoint = ((int)GetScalar(3) > 0) ? 1 : -1;
  mode      = ((int)GetScalar(4) > 0) ? 1 : 0;
  
  if(GetBufferInfo(bufno, index) != 2)
    return 14; /* data dimension miss match */

  if(step <= 0.0){
    printf("illegal step\n");
    return 3; /* illegal parameter */
  }  

  if(timeaxis == NULL)
    return 3; /* illegal parameter */

  if(*timeaxis == 'X' || *timeaxis == 'x'){
    nx = index[0];
    ny = index[1];
  }else{
    nx = index[1];
    ny = index[0];
  }
  
  data2 = (int**)gpmcmd_ldata_malloc2d(nx, ny, sizeof(int));
  data  = gpmcmd_ldata_ldata(bufno, nx, ny, timeaxis, viewpoint);
  if(data == NULL)
    return 15; /* buffer read error */
  
  rmin = data[0][0];
  rmax = data[0][0];
  
  for(i = 0; i < nx; i++){
    for(j = 0; j < ny; j++){
      if(data[i][j] > rmax)
        rmax = data[i][j];
      if(data[i][j] < rmin)
        rmin = data[i][j];
    }
  }
  
  hx = GpmCont.xSize / (float)(nx - 1);
  hy = GpmCont.ySize / (float)(ny - 1);

  if(GpmCont.xMode == 0){
    GpmCont.xMin = 0.0;
    GpmCont.xMax = (float)(nx-1);
  }

  if(GpmCont.yMode == 0){
    GpmCont.yMin = 0.0;
    GpmCont.yMax = (float)(ny-1);
  }
  GpmCont.axisType = 0;

  if(GpmCont.zMode == 0){
    zMin = rmin;
    zMax = rmax;
    GpmCont.zMin = (float)zMin;
    GpmCont.zMax = (float)zMax;
  }else{
    zMin = GpmCont.zMin;
    zMax = GpmCont.zMax;
/*
    if(GpmCont.zType == 1){
      zMin = (zMin > 0.0) ? log10(zMin) : -10;
      zMax = (zMax > 0.0) ? log10(zMax) :  10;
    }
*/
  }  

  kh = 0;
  for(i = 1; i <= 1000; i++){
    kh++;
    heit[kh - 1] = (float)(zMin + (double)(i - 1) * step);

    if(heit[kh - 1] > zMax || heit[kh - 1] > rmax){
      kh--;
      if(kh <= 0)
        return 16; /* internal routine error */
      break;
    }
    if(heit[kh - 1] < rmin)
      kh--;
    if(kh == 500)
      break;
  }
  
  printf("  Matrix Size  %d x %d\n", nx, ny);
  printf("  (scale: min = %g, max = %g, data: min = %g, max = %g)\n", 
         zMin, zMax, rmin, rmax);
  
  if(gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, 
           GpmCont.paperWidth, GpmCont.paperHeight) != 0)
    return 6; /* window does not exist */

  if(checktodvi() != 0)
    libgpm_dvi_write_param(&gpmdev_cont.dvi, GpmCont.factor, 
                           GpmCont.xOrigin, GpmCont.yOrigin);
  gfactor(GpmCont.factor);
  gnewpen(GpmCont.gColor);
  gpen(GpmCont.gLineWidth, GpmCont.gLineType, 0);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);

  i = 500;
  gpmcmd_cont_contln(data, data2, nx, ny, heit, i, kh, hx, hy, mode);
  gplot(gpmdev_cont.graph.xpre, gpmdev_cont.graph.ypre, 2);
  
  gflush();
  gclose();
  wrgpm();
  return 0;
}

#ifdef __cplusplus
}
#endif
