/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/color.cpp,v 1.1 2004/06/24 13:47:18 orrisroot Exp $ */

/************************************************
*                                               *
*        SET PEN COLOR                          *
*                                               *
*        COLOR  I1, I2                          *
*                                               *
*        I1   : GRAPH COLOR                     *
*        I2   : AXIS and FRAME COLOR            *
*                                               *
*        COLOR                                  *
*         0 : BLACK                             *
*         1 : BLUE                              *
*         2 : RED                               *
*         3 : MAGENTA                           *
*         4 : GREEN                             *
*         5 : SKY BLUE                          *
*         6 : YELLOW                            *
*         7 : WHITE                             *
*                                               *
*      Original coded by  S.HITOMI  02/13/1992  *
*                                               *
************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  char *name;
  int  no;
} gpm_color_t;

static gpm_color_t color[] = {
  {"black"  , 0}, {"blue" , 1}, {"red"    , 2}, {"magenta", 3},
  {"green"  , 4}, {"cyan" , 5}, {"skyblue", 5}, {"yellow" , 6},
  {"white"  , 7}, {"BLACK", 0}, {"BLUE"   , 1}, {"RED"    , 2},
  {"MAGENTA", 3}, {"GREEN", 4}, {"CYAN"   , 5}, {"SKYBLUE", 5},
  {"YELLOW" , 6}, {"WHITE", 7},
  {"gray1",   8}, {"gray2", 9}, {"gray3",  10},
  {"GRAY1",   8}, {"GRAY2", 9}, {"GRAY3",  10},
  {NULL,    0}
};

DLLEXPORT int mod_gpm_color(){
  int  number[2];
  char *name[2];
  int  i, n;
  
  /* LOAD SYSTEM PARAMETER */
  regpm();

  name  [0] =      GetString(0);
  name  [1] =      GetString(1);
  number[0] = (int)GetScalar(0);
  number[1] = (int)GetScalar(1);

  for(i=0; i < 2; i++){
    for(n=0; color[n].name != NULL; n++){
      if(name[i] != NULL && strcmp(name[i], color[n].name) == 0){
        number[i] = color[n].no;
        break;
      }
    }
  }
  for(i=0; i < 2; i++){
    if(number[i] < 0)
      return 3; /* illegal parameter */
    else
      number[i] %= MAX_COLOR;
  }
  
  GpmCont.gColor = number[0];
  GpmCont.fColor = number[1];
  
  wrgpm();
  return 0;
}

#ifdef __cplusplus
}
#endif
