/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: excel2buffer.cpp,v 1.2 2004/04/14 14:43:34 orrisroot Exp $ */

#include <windows.h>
#include <ddeml.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

// conversation info
struct channel_tag {
	DWORD conv;
	DWORD inst;
};
static struct channel_tag channel;

static DWORD   idDDEMLInst = 0L;
static BOOL GetNumericData (HDDEDATA hData);

// DDEʐM
static int ddeinit(char *service, char *topic)
{
	HCONV 	hConv = NULL;
	char	*pszService, *pszTopic;
	HGLOBAL hgService, hgTopic;
	long	lSize;
	HSZ		hszService = NULL;
	HSZ		hszTopic = NULL;

	// DDEMLiCuj
	if (!idDDEMLInst) {
	  DdeInitialize(&idDDEMLInst, (PFNCALLBACK)NULL/*DdeCallBack*/, APPCMD_CLIENTONLY, 0L);
	}							 

	// AvP[V쐬
	lSize = strlen( service );
	hgService = GlobalAlloc (GPTR, (int)((lSize)+1L)*sizeof(char));
	pszService = (char *) GlobalLock (hgService);
	strcpy(pszService, service);
	// gsbN쐬
	lSize = strlen( topic );
	hgTopic = GlobalAlloc (GPTR, (int)((lSize)+1L)*sizeof(char));
	pszTopic = (char *) GlobalLock (hgTopic);
	strcpy(pszTopic, topic);
	// ẽnh
	hszService = DdeCreateStringHandle(idDDEMLInst, (LPSTR)pszService, CP_WINANSI);	
	hszTopic = DdeCreateStringHandle(idDDEMLInst, (LPSTR)pszTopic, CP_WINANSI);	

	GlobalFree (hgService);
	GlobalFree (hgTopic);

	// Establish conversation 
	hConv = DdeConnect(idDDEMLInst, hszService, hszTopic, NULL);

	// AvP[Vڑ 
	if (hConv && idDDEMLInst) {
	  channel.conv = (DWORD) hConv;
	  channel.inst = (DWORD) idDDEMLInst;
	} else {
	  channel.conv = NULL;
	  channel.inst = NULL;
	}

	// free strings 
	DdeFreeStringHandle(idDDEMLInst, hszService);
	DdeFreeStringHandle(idDDEMLInst, hszTopic);

	if(hConv)
		return TRUE;
	else
		return FALSE;
}

// DDEʐMI
static void ddeterm()
{
	HCONV hConv = NULL;
	BOOL	bRC = 0;

	// ʐMnh
	hConv = (HCONV) channel.conv;

	// ؒf
	if (hConv)
	  bRC = DdeDisconnect(hConv);
}

// ddereq
static int ddereq(int srow, int scolumn, int erow, int ecolumn)
{
	WORD	wRequestFormat = CF_TEXT;
	DWORD	idDDEMLInst;
	HCONV 	hConv;
	CONVINFO ci;
	DWORD	dwResult=0, dwTimeout=10000;	// ҂10b
	HSZ		hszItem;
	char	szItem[1025];
	HDDEDATA	hData;

	// ʐMnh
	hConv = (HCONV) channel.conv;
	idDDEMLInst = channel.inst;

	// ʐMmF
	ci.cb = sizeof(CONVINFO);
	if (!DdeQueryConvInfo (hConv, (DWORD)QID_SYNC, &ci)) {
	  printf("DDE is not valid.\n");
	  return FALSE;
	}

	// ʐM
	sprintf(szItem, "r%dc%d:r%dc%d", srow, scolumn, erow, ecolumn);
	hszItem = DdeCreateStringHandle(idDDEMLInst, (LPSTR)szItem, CP_WINANSI);	

	// ʐM
	hData = DdeClientTransaction((LPBYTE) NULL,
				     0,
				     hConv,
				     hszItem,
				     wRequestFormat,
				     XTYP_REQUEST,
				     (DWORD) dwTimeout,
				     &dwResult);

	if (!hData) {
	    // ʐMs
		printf("DDE Error: DLL request failed.\n");
	} 
	else {
	    // SATELLITEɐݒ
	    if(!GetNumericData (hData))
			printf("The buffer is empty.\n");
	}


	// cleanup
	DdeFreeDataHandle (hData);
	if (hszItem)
	  DdeFreeStringHandle(idDDEMLInst, hszItem);

	return TRUE;
}

#define MAX_STR_LEN 350

// DDEf[^SATELLITEϐɑ
static BOOL GetNumericData (HDDEDATA hData)
{
	int		iM, iN, iCount, i, j;
	int		c, ws_flag;
	double 	*pr, *prs;
	char 	buf[MAX_STR_LEN];
	char  	*pch, *pchn;
	LPBYTE	pData;
	Buffer *work;
	int dim,idx[MAX_INDEX];

	pData = DdeAccessData (hData, NULL);

	// Figure out array dimensions
	pch = (char*)pData;
	iM = iN = iCount = 0;
	ws_flag = 1;
	while (*pch) {
	  // check for white space
	  if (strchr(" \t,",c=*pch)) {
	    if (ws_flag) {		// still working on white sp
	      pch++;
	      continue;
	    } else {
	      iCount++;		// count new element
	      ws_flag = (c=='\t') ? 0 : 1;
	      pch++;
	    }
	  } 
	  else 
	    if (c == '\n' || c == '\r') {
	      // check for blank line
	      if (!iCount && ws_flag) {
		pch++;
		continue;
	      }
	      // check if a string was in progress
	      if (!ws_flag)
		iCount++;
	      
	      ws_flag = 1;
	      // got new line, need to check for column count and
	      // row check
	      if (iN) {
		// check if column count is consistant
		if (iN < iCount)
		  iN = iCount;
		
		iM++;  // increment row count
	      } else {
		// first row read so record column count
		iN = iCount;
		iM = 1;
	      }
	      iCount = 0;
	      pch++;
	      
	    } else {
	      ws_flag = 0;
	      pch++;
	    }
	}
	
	// f[^`FbN
	if (iM*iN == 0) {
		return FALSE;
	}

	// SATELLITEϐ
	if(iN==1)
		dim = 1;
	else
		dim = 2;
	idx[0]=iM;
	idx[1]=iN;
    work = (Buffer *)AllocBuffer(IndexSize(dim, idx));
	if (work == NULL)
		return FALSE;
	
	// eLXgBuffer^
	pch = (char*)pData;
	iCount  = iM*iN;
	pr = prs = work;

	for (i=0; i<iM; i++) {
		for (j=0; j<iN; j++) {
			// ؂o
			pchn = strpbrk (pch, "\t\r\n");
		  
			// Buffer^ϊ
			*buf = 0x00;
			strncat (buf, pch, (int)(pchn ? pchn-pch : strlen(pch)));
			*pr = atof (buf);
			pr++;
			// advance text buffer and set pr index
			if (!pchn)
				goto loop;
			pch = pchn;
			pch++;
			if (*pch == '\n') pch++; // extra increment for CRLF
		}
	}
loop:

	ReturnSeries( work, dim, idx);
	DdeUnaccessData (hData);
	
	return TRUE;
}

//
// data transration from EXCEL to SATELLITE buffer
//

DLLEXPORT int mod_dcm_excel2buffer()
{
  int	srow,scolumn,erow,ecolumn;
  char	szSheet[256];
  char	*sheet;
  
  //V[g
  sheet = GetString(0);
  if(sheet == NULL)
	  strcpy(szSheet, "sheet1");
  else
	  strcpy(szSheet, sheet);
  //Jns
  srow = GetScalar(1);
  //Jn
  scolumn = GetScalar(2);
  //Is
  erow = GetScalar(3);
  //I
  ecolumn = GetScalar(4);

  //ʐM
  if(!ddeinit("excel",szSheet))
	return 10;

  //ʐM
  ddereq(srow, scolumn, erow, ecolumn);

  //ʐMؒf
  ddeterm();

  return 0;
}

#ifdef __cplusplus
}
#endif
