/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: buffer2excel.cpp,v 1.2 2004/04/14 14:43:34 orrisroot Exp $ */

#include <windows.h>
#include <ddeml.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

// conversation info
struct channel_tag {
	DWORD conv;
	DWORD inst;
};
static struct channel_tag channel;

static DWORD   idDDEMLInst = 0L;
static HDDEDATA ArrayToText (DWORD, HSZ, Buffer *, int, int []);

// DDEʐM
static int ddeinit(char *service, char *topic)
{
	HCONV 	hConv = NULL;
	char	*pszService, *pszTopic;
	HGLOBAL hgService, hgTopic;
	long	lSize;
	HSZ		hszService = NULL;
	HSZ		hszTopic = NULL;

	// DDEMLiCuj
	if (!idDDEMLInst) {
	  DdeInitialize(&idDDEMLInst, (PFNCALLBACK)NULL/*DdeCallBack*/, APPCMD_CLIENTONLY, 0L);
	}							 

	// AvP[V쐬
	lSize = strlen( service );
	hgService = GlobalAlloc (GPTR, (int)((lSize)+1L)*sizeof(char));
	pszService = (char *) GlobalLock (hgService);
	strcpy(pszService, service);
	// gsbN쐬
	lSize = strlen( topic );
	hgTopic = GlobalAlloc (GPTR, (int)((lSize)+1L)*sizeof(char));
	pszTopic = (char *) GlobalLock (hgTopic);
	strcpy(pszTopic, topic);
	// ẽnh
	hszService = DdeCreateStringHandle(idDDEMLInst, (LPSTR)pszService, CP_WINANSI);	
	hszTopic = DdeCreateStringHandle(idDDEMLInst, (LPSTR)pszTopic, CP_WINANSI);	

	GlobalFree (hgService);
	GlobalFree (hgTopic);

	// AvP[Vڑ 
	hConv = DdeConnect(idDDEMLInst, hszService, hszTopic, NULL);

	if (hConv && idDDEMLInst) {
	  channel.conv = (DWORD) hConv;
	  channel.inst = (DWORD) idDDEMLInst;
	} else {
	  channel.conv = NULL;
	  channel.inst = NULL;
	}

	// free nh 
	DdeFreeStringHandle(idDDEMLInst, hszService);
	DdeFreeStringHandle(idDDEMLInst, hszTopic);

	if(hConv)
		return TRUE;
	else
		return FALSE;
}

// DDEʐMI
static void ddeterm()
{
	HCONV hConv = NULL;
	BOOL	bRC = 0;

	// ʐMnh
	hConv = (HCONV) channel.conv;

	// ؒf
	if (hConv)
	  bRC = DdeDisconnect(hConv);
}

// ddepoke
static int ddepoke(Buffer *data, int dim, int index[])
{
	DWORD	idDDEMLInst;
	HCONV 	hConv;
	CONVINFO ci;
	DWORD	dwResult=0, dwTimeout=10000;	// ҂10b
	HSZ		hszItem;
	char	szItem[1025];
	HDDEDATA	hData, hddeResult;
  
	// ʐMnh
	hConv = (HCONV) channel.conv;
	idDDEMLInst = channel.inst;

	// ʐMmF
	ci.cb = sizeof(CONVINFO);
	if(!DdeQueryConvInfo (hConv, QID_SYNC, &ci)) {
	  printf("The first argument 'channel' is not valid.\n");
	  return FALSE;
	}

	// ʐM
	sprintf(szItem, "r1c1:r%dc%d", index[0], index[1]);
	hszItem = DdeCreateStringHandle(idDDEMLInst, (LPSTR)szItem, CP_WINANSI);	

	// ʐMf[^
	hData = ArrayToText (idDDEMLInst, hszItem, data, dim, index);

	// ʐM
	hddeResult = 
	DdeClientTransaction(/*(void FAR *)*/(LPBYTE) hData,
			     (DWORD) -1,
			     hConv,
			     hszItem,
			     CF_TEXT,
			     XTYP_POKE,
			     (DWORD) dwTimeout,
			     &dwResult);

	// cleanup
	if (hszItem)
	  DdeFreeStringHandle(idDDEMLInst, hszItem);

	return (int)hddeResult;
}

// useful defines
#define SZ_TAB	"\t"
#define SZ_CRLF "\r\n"

//
// datazeLXg`f[^ɕύX
//
static HDDEDATA ArrayToText (DWORD idInst, HSZ hszItem,
					  Buffer *data, int dim, int index[])
{
	long	i, j, m, n;
	HDDEDATA hData, hNewData;
	DWORD	iSize, iOffset = 0; 
	DWORD	iszCRLF = strlen(SZ_CRLF);
	char	szBuff[512];
	Buffer	*dat;

	m = index[0];
	n = index[1];

	// CF_TEXT`̃f[^IuWFNghData쐬
	hData = DdeCreateDataHandle(idInst, 
					  NULL,
					  0,
					  0, 
					  hszItem, 
					  CF_TEXT, 
					  0);
	// hDataɃf[^ݒ      
	dat = data;
	for (i=0; i<m; i++) {
		for (j=0; j<n; j++) {
			sprintf (szBuff, "%.16g", *dat);
			if (j<n-1)
				strcat (szBuff, SZ_TAB);
			iSize = strlen(szBuff);
			if ((hNewData = DdeAddData (hData, (LPBYTE)szBuff, iSize, iOffset))==0) {
				break; // error condition
			}else
				hData = hNewData;
			iOffset += iSize;
			dat++;
		}
		if ((hNewData = DdeAddData (hData, (LPBYTE)SZ_CRLF, iszCRLF, iOffset))==0) {
			break;	// error condition
		}else
			hData = hNewData;
		iOffset += iszCRLF;
	}
	  
	// nullݒ
	if ((hNewData = DdeAddData (hData, (LPBYTE) "", 1, iOffset))!=0)
		hData = hNewData;
	
	return hData;
}


//
// SATELLITEExcelփf[^]R}h
//

DLLEXPORT int mod_dcm_buffer2excel()
{
  Buffer *data;
  int	 dim, idx[MAX_INDEX];
  char	szSheet[256];
  char	*sheet;
  
  //f[^IuWFNg
  if (( data = GetSeries(0, &dim, idx) ) == NULL )
    return 4;
  if(dim==1)
	  idx[1] = 1;
  //V[g
  sheet = GetString(1);
  if(sheet == NULL)
	  strcpy(szSheet, "sheet1");
  else
	  strcpy(szSheet, sheet);

  //DDEʐM
  //́AAvP[VƃgsbN
  if(!ddeinit("excel",szSheet))
    return 10;

  //]
  ddepoke(data, dim, idx);

  //DDEʐMI
  ddeterm();

  return 0;
}

#ifdef __cplusplus
}
#endif
