/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: matfile.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */

#define mxMAXNAM  32	/* maximum name length */

typedef enum {
	mxCELL_CLASS = 1,
	mxSTRUCT_CLASS,
	mxOBJECT_CLASS,
	mxCHAR_CLASS,
	mxSPARSE_CLASS,
	mxDOUBLE_CLASS,
	mxSINGLE_CLASS,
	mxINT8_CLASS,
	mxUINT8_CLASS,
	mxINT16_CLASS,
	mxUINT16_CLASS,
	mxINT32_CLASS,
	mxUINT32_CLASS,
	mxINT64_CLASS,		/* place holder - future enhancements */
	mxUINT64_CLASS,		/* place holder - future enhancements */
	mxUNKNOWN_CLASS = -1
} mxClassID;

typedef enum {
    mxREAL,
    mxCOMPLEX
} mxComplexity;

typedef double MatReal;                /* "real" data type used in model.mat  */
typedef struct LogVar_Tag LogVar;
typedef struct StructLogVar_Tag StructLogVar;

typedef struct MatrixData_Tag {
  char           name[mxMAXNAM];     /* Name of the variable                  */
  int            nRows;              /* number of rows                        */
  int            nCols;				 /* number of columns                     */
  void           *re;                /* pointer to real part of the data      */
  void           *im;                /* pointer to imaginary part, if complex */
  //DTypeId        dTypeID;            /* data type id                          */
  int            dTypeID;            /* data type id                          */
  size_t         elSize;             /* element size in bytes                 */
  mxClassID      mxID;               /* mxId corresponding to this dTypeID    */
  unsigned int   logical;            /* is this a logical array ?             */
  unsigned int   complex;            /* is this a complex matrix?             */
} MatrixData;

struct LogVar_Tag {
    MatrixData data;                  /* Container for name, data etc.,       */
    int      rowIdx;                /* current row index                    */
    int      wrapped;               /* number of times the circular buffer
                                       * has wrapped around                   */
    int      nDataPoints;            /* total number of data points logged   */
    int      usingDefaultBufSize;    /* used to print a message at end       */
    int      decimation;             /* decimation factor                    */
    int      numHits;                /* decimation hit count                 */

    LogVar   *next;
};


typedef struct SignalsStruct_Tag {
    int          numActiveFields;   /* number of active fields                */
    char         *fieldNames;
    int          numSignals;
    LogVar       *values;
    MatrixData   *labels;
    MatrixData   *plotStyles;
    MatrixData   *titles;
    MatrixData   *blockNames;

} SignalsStruct;

struct StructLogVar_Tag {
    char          name[mxMAXNAM];   /* Name of the ML Struct variable         */
    int           numActiveFields;  /* number of active fields                */
    BOOL          logTime;
    void          *time;
    SignalsStruct signals;
    MatrixData    *blockName;

    StructLogVar  *next;
};

typedef struct MatItem_tag {
  int		type;
  int		nbytes;
  const void *data;
} MatItem;

typedef enum {
    DATA_ITEM,
    MATRIX_ITEM,
    STRUCT_LOG_VAR_ITEM,
    SIGNALS_STRUCT_ITEM
} ItemDataKind;


#define matUNKNOWN                  0
#define	matINT8                     1
#define	matUINT8                    2
#define	matINT16                    3
#define	matUINT16                   4
#define	matINT32                    5
#define	matUINT32                   6
#define	matFLOAT                    7
#define	matDOUBLE                   9
#define	matMATRIX                  14

#define matKEY                 0x4D49
#define matVERSION             0x0100
#define matVERSION_INFO_OFFSET   124L

#define matINT64_ALIGN(e)      ( ( ((unsigned)(e))+7 ) & (~7) )
#define matTAG_SIZE            (sizeof(int) << 1)

#define DEFAULT_BUFFER_SIZE      1024     /* used if maxRows=0 and Tfinal=0.0 */

#define FREE(m) if (m != NULL) free(m)

#ifdef __cplusplus
extern "C" {
#endif

/* function declation */
BOOL MatfileCreateHeader( char* matname );
void MatfileCreate( char* tag,
	double* re, double* im, int nRows, int nCols);
void MatfileCreateClose(char* matname);
void RTSim_StopDataLogging(FILE *file);
char* RTSim_FixupLogVar(LogVar *var);
int RTSim_WriteMat5FileHeader(FILE *fp);
int RTSim_WriteItemToMatFile(FILE *fp, MatItem *pItem, ItemDataKind itemKind);
int RTSim_ProcessMatItem(	   FILE         *fp,
                           MatItem      *pItem,
                           ItemDataKind itemKind,
                           int          cmd);
int RTSim_GetMatIdFromMxId(mxClassID mxID);

#ifdef __cplusplus
}
#endif
