/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: dcm_fifo.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#ifndef __DCM_FIFO_H__
#define __DCM_FIFO_H__

typedef struct _DCM_FIFO_CELL {
  double data;
  struct _DCM_FIFO_CELL *next;
} DCM_FIFO_CELL ;

typedef struct {
  DCM_FIFO_CELL *top,*last;
  unsigned long size;
} DCM_FIFO ;

typedef struct _DCM_FIFO_LIST_CELL {
  DCM_FIFO            *fifo;
  struct _DCM_FIFO_LIST_CELL *next;
} DCM_FIFO_LIST_CELL ;

typedef struct {
  unsigned long size;
  DCM_FIFO_LIST_CELL *top,*last;
} DCM_FIFO_LIST ;

/* DCM_FIFO_CELL *DCM_FIFO_CELL_New(); */
DCM_FIFO      *DCM_FIFO_New();
void           DCM_FIFO_Init(DCM_FIFO *);
void           DCM_FIFO_Delete(DCM_FIFO *);
void           DCM_FIFO_push(DCM_FIFO *, double);
double         DCM_FIFO_pop(DCM_FIFO *, int *);

DCM_FIFO_LIST *DCM_FIFO_LIST_New();
int  DCM_FIFO_LIST_Add(DCM_FIFO_LIST *, DCM_FIFO *);
void DCM_FIFO_LIST_Delete(DCM_FIFO_LIST *);
DCM_FIFO *DCM_FIFO_LIST_Get(DCM_FIFO_LIST *, unsigned long);
unsigned long DCM_FIFO_LIST_TotalSize(DCM_FIFO_LIST *fifo_list);
#endif
