/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: buffer2text.cpp,v 1.3 2004/12/17 12:39:50 orrisroot Exp $ */
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

using namespace std;

#ifdef __cplusplus
extern "C" {
#endif

#undef fprintf

typedef struct {
  int dim;
  int index[MAX_INDEX];
  int length;
  Buffer *data;
  string *sdata;
} Buffer_Struct;

DLLEXPORT int mod_dcm_buffer2text()
{
  int i,j,k,l, bflag;
  Buffer_Struct *bs;

  int stop_flag;        /* Number of Input Data */

  char *dm_fmt;
  char *fname;
  char *format;
  double *data_buf;
  string *sdata_buf;

  FILE *fp;
  int max_length,format_length;

  /* Get Output File Name*/
  fname=GetString(0);
  if(fname==NULL)
    return (1);

  /* Get Output Format String */
  format=GetString(1);
  if(format==NULL)
    return (1);

  /* Format String Check */
  stop_flag=0;
  format_length=strlen(format);
  for(i=0;i<format_length;i++){
    if((format[i]=='%')&&(format[i+1]!='%'))
      stop_flag++;
  }

  /* Get Series Buffers */
  bs=(Buffer_Struct *)malloc(sizeof(Buffer_Struct)*stop_flag);
  /* Format String Analysis */
  for(i=0;i<stop_flag;i++){
    bs[i].data = syscom->SCGetSeriesMem(2+i,&bs[i].dim,bs[i].index);
    if(bs[i].data==NULL){
      bs[i].sdata = syscom->SCGetStringMem(2+i,&bs[i].dim,bs[i].index);
      if(bs[i].sdata==NULL){
        free(bs);
        return (1);
      }
    }
    bs[i].length=IndexSize(bs[i].dim,bs[i].index);
    if(bs[i].dim>1){
      printf("Warning : arg[%d] isn't 1 dimension data\n",i+3);
    }
  }

  /* Chack Max Buffer size */
  max_length=bs[0].length;
  for(i=0;i<stop_flag;i++){
    if(max_length<bs[i].length)
      max_length=bs[i].length;
  }

  /* Open Output File */
  fp=fopen(fname,"w");
  if(fp==NULL)
    return (2);

  /* Data Output */
  data_buf = (double *)malloc(sizeof(double)*stop_flag);
  sdata_buf = new string[stop_flag];
  dm_fmt=(char *)malloc(sizeof(char)*format_length+1);
  for(i=0;i<max_length;i++){
    /* Correct Data */
    for(j=0;j<stop_flag;j++){
      if(bs[j].length > i){
        if(bs[j].data){
          data_buf[j]=bs[j].data[i];
          sdata_buf[j] = "";
        }else{
          data_buf[j]=0.0;
          sdata_buf[j]=bs[j].sdata[i].c_str();
        }
      } else {
	data_buf[j]=0.0;
        sdata_buf[j]="";
      }
    }

    /* Format String Analysis */
    k=0;l=0;
    for(j=0;j<format_length;j++){
      /* if it find "%" symbol  */
      if(format[j]=='%'){
	dm_fmt[l++]='%';
        bflag = 1;
	while(bflag){
	  /* Bad Format. goto Error */
	  if(j>=format_length){
	    fclose(fp);
	    return (1);
	  }
	  switch(format[++j]){
	  case 'd':
	  case 'i':
	  case 'o':
	  case 'u':
	  case 'x':
	  case 'X': dm_fmt[l++]=format[j];dm_fmt[l]='\0';l=0;
	            fprintf(fp,dm_fmt,(int)data_buf[k]);
                    k++; bflag = 0; break;
	  case 'f':
	  case 'e':
	  case 'E':
	  case 'g': 
	  case 'G': dm_fmt[l++]=format[j];dm_fmt[l]='\0';l=0;
                    fprintf(fp,dm_fmt,data_buf[k]); k++;
                    bflag = 0; break;
          case 's': dm_fmt[l++]=format[j];dm_fmt[l]='\0';l=0;
                    fprintf(fp,dm_fmt,sdata_buf[k].c_str());
                    k++; bflag = 0; break;
          case '%': dm_fmt[l++]=format[j];
                    bflag = 0; break;
	  default : dm_fmt[l++]=format[j]; break;
	  }
	}
      } else {
	dm_fmt[l++]=format[j];
      }
    }
    dm_fmt[l]='\0';
    fprintf(fp,dm_fmt);
  }

  /* Output File Close */
  fclose(fp);

  free(dm_fmt);
  free(data_buf);
  delete [] sdata_buf;
  free(bs);

  return 0;
}
#ifdef __cplusplus
}
#endif
