/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: buffer2matlab.cpp,v 1.2 2004/04/14 14:43:34 orrisroot Exp $ */
#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifndef WIN32
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int type;    /* Computer Type */
  int rows;    /* Number of Data rows */
  int cols;    /* Number of Data columns */
  int imgf;    /* Flag Complex ( 0 = REAL , 1 = COMPLEX ) */
  int namelen; /* Length of Name for Data */
} MAT_Header ;

DLLEXPORT int mod_dcm_buffer2matlab()
{
  register int i,j;
  int dim,index[10];
  Buffer *data;
  char *fname,*dname;
  FILE *fp;
  MAT_Header mat;

  /* Get File Name */
  fname=GetString(0);
  if(fname==NULL)
    return(1);

  /* Get Data Name */
  dname=GetString(1);
  if(dname==NULL)
    return(1);

  /* Get Buffer */
  if (!strcmp(GetArgType(2),"scalar")){
    dim=1;
    index[0]=1;
    data=AllocBuffer(1);
    data[0]=GetScalar(2);
  } else {
    data=GetSeries(2,&dim,index);
    if(data==NULL)
      return(1);
  }

  if(dim>2) return(3);

  /* Output File Open */
  fp=fopen(fname,"w");
  if(fp==NULL)
    return(2);

  /* Data Output */
#if ( defined(i386) || defined(__alpha) )
  mat.type=0;
#else
  mat.type=1000;
#endif
  mat.imgf=0;
  mat.namelen = strlen(dname)+1;
  switch(dim){
  case 1:
    mat.rows=index[0];
    mat.cols=1;
    break;
  case 2:
    mat.rows=index[0];
    mat.cols=index[1];
    mat.type+=100;
    break;
  }
  fwrite(&mat,sizeof(mat),1,fp);
  fwrite(dname, mat.namelen*sizeof(char),1,fp);

  for(i=0;i<mat.rows;i++){
    for(j=0;j<mat.cols;j++){
      fwrite(&data[i*mat.cols+j],sizeof(double),1,fp);
    }
  }
  /* Output File Close */
  fclose(fp);
  FreeBuffer(data);
  return 0;
}

#ifdef __cplusplus
}
#endif

#else
#ifdef __cplusplus
extern "C" {
#endif
#include <malloc.h>
#include "matfile.h"

DLLEXPORT int mod_dcm_buffer2matlab()
{
  register int i,j;
  int dim,index[10];
  Buffer *data;
  char *fname,*dname;
  double *re;
  int signalWidth;

  /* Get File Name */
  fname=GetString(0);
  if(fname==NULL)
    return(1);

  /* Get Data Name */
  dname=GetString(1);
  if(dname==NULL)
    return(1);

  /* Get Buffer */
  if (!strcmp(GetArgType(2),"scalar")){
    dim=1;
    index[0]=1;
	index[1]=1;
    data=AllocBuffer(1);
    data[0]=GetScalar(2);
  } else {
    data=GetSeries(2,&dim,index);
    if(data==NULL)
      return(1);
	if(dim==1)
		index[1]=1;
  }
  /*
   *
   */
	if(!MatfileCreateHeader( fname ))
		return FALSE;
	signalWidth = index[1];
	re = (double *)malloc(index[0] * signalWidth * sizeof(double));
	//re = AllocBuffer(index[0] * signalWidth);
#if 1
	for(i = 0; i < index[0]; i++) {
		for(j = 0; j < signalWidth; j++) {
			re[j*index[0]+i] = *data++;
		}
	}
#else
	memcpy(re, data, index[0] * signalWidth * sizeof(double));
#endif
	MatfileCreate(	dname,	/* workspace name */
					re,					/* real */
					NULL,				/* imaginary */
					signalWidth,		/* row */
					index[0]			/* column */
					);
	MatfileCreateClose( fname );
	//free(re);
	//FreeBuffer(re);

  FreeBuffer(data);
  return 0;
}

#ifdef __cplusplus
}
#endif
#endif
