/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/weight.cpp,v 1.4 2005/02/22 07:40:22 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jun.26 1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename weight.c                       *
*           BPS WEIGHT command                  *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
	get parameters for weight  
***********************************************/

DLLEXPORT int mod_bps_weight()
{
  int    interval;
  char   stor_mode;
  char  *str;

  rebps();

  /* GetString() ʸĹ FILE_LENGTH-5 ۤEϤɤʤE */
  strcpy(bps_cont.bps_sp.LrnInitWgtFile, GetString(0));
  strcat(bps_cont.bps_sp.LrnInitWgtFile, ".bhw");

  strcpy(bps_cont.bps_sp.WgtHistoryFile, GetString(1));
  strcat(bps_cont.bps_sp.WgtHistoryFile, ".bhw");

  interval = (int)GetScalar(2);
  if (interval < 0)
		return 200; /* Illigal Parameter( Interval ) */

  str       = GetString(3);
  stor_mode = toupper(str[0]);
  if(str == NULL)
		return 2; /* illegal parameter */
  if ((stor_mode != BPS_STOREMODE_APPEND) &&
      (stor_mode != BPS_STOREMODE_OVERWRITE))
		return 202; /* Unknown Store Mode */

  bps_cont.bps_sp.WgtStorInterval = interval;
  bps_cont.bps_sp.WgtStorMode    = stor_mode;

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif