/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/walgo.cpp,v 1.4 2005/02/22 07:40:22 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version				* 
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jun.26 1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename winit.c                        *
*           BPS WALGO command                   *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
	get parameters for weight initialize  
***********************************************/

DLLEXPORT int mod_bps_walgo()
{
  char  *str;
  char   init_algo;

  rebps();

  str       = GetString(0);
  init_algo = toupper(str[0]);

  if(str == NULL)
		return 2; /* illegal parameter */
  if ((init_algo != BPS_INITALGO_JIA) &&
      (init_algo != BPS_INITALGO_RANDUM))
    return 210; /* Unknown Algorithm */

  bps_cont.bps_sp.InitAlgo = init_algo;

  strcpy(bps_cont.bps_sp.InitWgtFile, GetString(1));
  strcat(bps_cont.bps_sp.InitWgtFile, ".bhw");

  bps_cont.bps_sp.Seed       = (int)GetScalar(2);
  bps_cont.bps_sp.MaxInitWgt =      GetScalar(3);
  bps_cont.bps_sp.MinInitWgt =      GetScalar(4);

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif