/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/teach.cpp,v 1.3 2005/02/21 11:53:13 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename teacher.c                      *
*           BPS TEACH command                   *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
	get input and teach data parameters
***********************************************/

DLLEXPORT int mod_bps_teach()
{
  int    f_ptrn, l_ptrn;

  rebps();

  /* GetString() ʸĹ FILE_LENGTH-5 ۤEϤɤʤE */
  strcpy(bps_cont.bps_sp.InputFile, GetString(0));
  strcat(bps_cont.bps_sp.InputFile, ".dat");

  strcpy(bps_cont.bps_sp.TeachFile, GetString(1));
  strcat(bps_cont.bps_sp.TeachFile, ".dat");

  f_ptrn = (int)GetScalar(2);
  l_ptrn = (int)GetScalar(3);

  if (f_ptrn < 0 || l_ptrn < 0)
		return 204; /* Illigal Parameter( Pattern Number ) */
  if (f_ptrn > l_ptrn)
		return 205; /* First Pattern Number Is Larger Than Last Pattern */

  bps_cont.bps_sp.LrnFirstPtrn = f_ptrn;
  bps_cont.bps_sp.LrnLastPtrn  = l_ptrn;

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif