/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/setrec.cpp,v 1.4 2005/02/22 04:32:19 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename brec.c                         *
*           BPS SETREC command                  *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
	get parameters for recognize  
***********************************************/

DLLEXPORT int mod_bps_setrec()
{
  int   w_hisno;
  int   f_ptrn, l_ptrn;
  int   i_lyr,  o_lyr;

  rebps();

  strcpy(bps_cont.bps_sp.TestWgtFile, GetString(0));
  strcat(bps_cont.bps_sp.TestWgtFile, ".bhw");

  strcpy(bps_cont.bps_sp.TestFile,    GetString(2));
  strcat(bps_cont.bps_sp.TestFile,    ".dat");

  strcpy(bps_cont.bps_sp.ActFile,     GetString(7));
  strcat(bps_cont.bps_sp.ActFile,     ".brc");

  w_hisno = (int)GetScalar(1);
  f_ptrn  = (int)GetScalar(3);
  l_ptrn  = (int)GetScalar(4);
  i_lyr   = (int)GetScalar(5);
  o_lyr   = (int)GetScalar(6);

  if (w_hisno < 0)
		return 203; /* Parameter File Open Error */
  if (f_ptrn < 0 || l_ptrn < 0)
		return 204; /* Illigal Parameter( Pattern Number ) */
  if (f_ptrn > l_ptrn)
		return 205; /* First Pattern Number Is Larger Than Last Pattern */
  if (i_lyr < 0 || o_lyr < 0)
		return 206; /* Illigal Parameter( Layer Number ) */
  if (i_lyr > o_lyr)
		return 207; /* Input Layer Number Is Too Large */

  bps_cont.bps_sp.WgtHistoryNo  = w_hisno;
  bps_cont.bps_sp.TestFirstPtrn = f_ptrn;
  bps_cont.bps_sp.TestLastPtrn  = l_ptrn;
  bps_cont.bps_sp.InputLayer    = i_lyr;
  bps_cont.bps_sp.OutputLayer   = o_lyr;

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif