/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/rwbps.cpp,v 1.5 2005/02/23 04:36:26 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#include "libbps.h"

/*******************************************************************
 **      File Name : rwbps.c                                      **
 **                                                               **
 **          System Common Area Read / Write Routine              **
 **                   for BPS Module                              **
 **                                                               **
 ******************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
# define FOPEN_MODE_R  "rb"
# define FOPEN_MODE_W  "wb"
# define FOPEN_MODE_RP "rb+"
#else
# define FOPEN_MODE_R  "r"
# define FOPEN_MODE_W  "w"
# define FOPEN_MODE_RP "r+"
#endif

int rebps()
{
  FILE  *spfp;
  char  fname[FILE_LENGTH];

  snprintf(fname, FILE_LENGTH, "%s/%s", get_tmpdir(), BPS_CONTEXT_FILE);

  if ((spfp = fopen(fname, FOPEN_MODE_R)) == NULL) {
    perror( "<<BPS:Error>>  Can't Open Parameter File (rebps)" );
    return -1;
  }

  fread(&bps_cont.bps_sp, sizeof(bps_pr_t), 1, spfp);
  fclose(spfp);
  return 0;
}

int wrbps()
{
  FILE *spfp;
  char  fname[FILE_LENGTH];

  snprintf(fname, FILE_LENGTH, "%s/%s", get_tmpdir(), BPS_CONTEXT_FILE);

  if ((spfp = fopen(fname, FOPEN_MODE_W)) == NULL) {
    perror( "<<BPS:Error>>  Can't Open Parameter File(wrbps)" );
    return -1;
  }

  fwrite(&bps_cont.bps_sp, sizeof(bps_pr_t), 1, spfp);
  fclose(spfp);
  return 0;
}


#ifdef __cplusplus
}
#endif
