/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/reclib.cpp,v 1.6 2005/02/22 07:40:22 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "libbps.h"

/************************************************
 *                                               *
 *       Back Propergation Simurator(BPS)        *
 *             subroutine package                *
 *               Ver                             *
 *         coded         in Nov.15 1990          *
 *         coded by      K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename testlib.c                      *
 *           BP testing subroutine               *
 *                                               *
 ************************************************/

#ifdef __cplusplus
extern "C" {
#endif


/************************************************
 * system initialize
 ************************************************/
int rec_system_initialize()
{
  if (access(bps_cont.TestFile, 0) == -1)
		return 40; /* Input File Isn't Exist */

  /* CALCULATE WgtBlockSize, ErrBlockSize AND ActBlockSize */
  SetNumOfLink();

  if ((bps_cont.TestFirstPtrn == 0) || (bps_cont.TestLastPtrn == 0)) {
    bps_cont.TestFirstPtrn = 1;
    bps_cont.TestLastPtrn = GetNumOfRecord(bps_cont.TestFile);
  }
  bps_cont.NumOfPtrn = bps_cont.TestLastPtrn - bps_cont.TestFirstPtrn + 1;

  bps_cont.InputData = (float **)bps_malloc2D(bps_cont.NumOfPtrn, 
                                              bps_cont.NumOfCell
                                              [bps_cont.InputLayer],
                                              sizeof(float));
  if (bps_cont.InputData == NULL)
		return 41; /* Can't Allocate To \"InputData\" */

  ReadData(bps_cont.TestFile, bps_cont.InputData, bps_cont.TestFirstPtrn,
           bps_cont.TestLastPtrn, bps_cont.NumOfCell[bps_cont.InputLayer]);

  /* ALLOCATE for activation buffer */
  bps_cont.act_buf = (float*)emalloc(sizeof(float)*(bps_cont.NumOfCell
                                          [bps_cont.OutputLayer]+1));
  if (bps_cont.act_buf == NULL)
		return 48; /* Can't Allocate To \"active_data\" */

  /* ALLOCATE for error buffer */
  bps_cont.ErrBuffer = (float*)emalloc(sizeof(float)*(bps_cont.NumOfCell
                                            [bps_cont.OutputLayer]+1));
  if (bps_cont.ErrBuffer == NULL)
		return 49; /* Can't Allocate To \"ErrBuffer\" */

	return 0;
}


/************************************************
  system end
  ************************************************/
void rec_system_end()
{
  bps_free2D((char**)bps_cont.InputData);
}


/************************************************
  test routine
  input:
  in_data  : input data
  ************************************************/
void test_network(float in_data[])
{
  int       laynum, unit;
  double    net;

  bps_cel_t    *cell_pt, *cur_cel;
  bps_ilin_t   *cur_ilin;

  for (unit = 1; unit <= bps_cont.NumOfCell[bps_cont.InputLayer]; unit++) {
    cur_cel = bps_cont.BPNet[bps_cont.InputLayer][unit].CellNode;
    cur_cel->Net = (double)in_data[unit-1];
    cur_cel->Active = FuncSelect(cur_cel->CharFunc, cur_cel->Net);
  }
  for (laynum = bps_cont.InputLayer + 1; laynum <=bps_cont. OutputLayer;
       laynum++) {
    for (unit = 1; unit <= bps_cont.NumOfCell[laynum]; unit++) {
      net = 0.0;

      cur_cel = bps_cont.BPNet[laynum][unit].CellNode;
      cur_ilin = Getintoplist(cur_cel);

      while (cur_ilin != NULL) {
        cell_pt = cur_ilin->InputCell;
        net += cur_ilin->Weight * cell_pt->Active;
        cur_ilin = Getinfwdlist(cur_ilin);
      }

      cur_cel->Net = net;
      cur_cel->Active = FuncSelect(cur_cel->CharFunc, net);
    }
  }
}

#ifdef __cplusplus
}
#endif
