/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/rec.cpp,v 1.5 2005/03/28 09:45:43 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"
#include "libgpm.h"

/************************************************
*						*
*	Back Propergation Simurator(BPS)	*
*	      subroutine package		*
*	  	Ver 4.0 			*
*	  coded		in May.17 1989		*
*	  last modified in Jul.3  1990		*
*	  coded by 	Y.Okamura		*
*	  modified by   K.Kuroda		*
*						*
*************************************************
*						*
*	filename tstmain.c 			*
*	    BP testing controler		*
*						*
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/************************************************
  testing main routine
  ************************************************/

DLLEXPORT int mod_bps_rec()
{
  char     rem[100], teach_file[FILE_LENGTH], err_file[FILE_LENGTH];
  char     *str;
  int      nargs;
  int      ptrn_no, unit_no, dmode;
  int      disp_flag, teach_flag, file_out_flag, err_flag;
  float    err, error = 0.0;
  bps_cel_t   *cell_pt;

  rebps();

  /* GET PARAMETERS */

  nargs         = GetArgNum();
  file_out_flag = (int)GetScalar(0);
  disp_flag     = (int)GetScalar(1);

  if ((file_out_flag != 0) && (file_out_flag != 1))
    return 43; /* Illigal Parameter 1 */
  if ((disp_flag != 0) && (disp_flag != 1))
    return 44; /* Illigal Parameter 2 */

  teach_flag = 0;
  err_flag   = 0;

  if (disp_flag) {
    if (nargs == 2) {
      printf("\tdisplay mode( 1 - 4 ) = ");
      if(sl4_getstr(rem, 100) != NULL)
	sscanf(rem, "%d", &bps_cont.DisplayMode);
    } else {
      dmode = (int)GetScalar(2);
      bps_cont.DisplayMode = dmode;
    }
    if(bps_cont.DisplayMode > 4 || bps_cont.DisplayMode < 1)
      return 2; /* illegal parameter */

    if ((bps_cont.DisplayMode == BPS_TRACEMODE_COLOR) ||
	(bps_cont.DisplayMode == BPS_TRACEMODE_SIZE)) {
      switch (nargs) {
      case 2:
      case 3:
	printf("\tminimum value = ");
        if(sl4_getstr(rem, 100) != NULL)
	  sscanf(rem, "%f", &bps_cont.MinScale);
	/* through */
      case 4:
	printf("\tmaximum value = ");
        if(sl4_getstr(rem, 100) != NULL)
	  sscanf(rem, "%f", &bps_cont.MaxScale);
	break;
      }

      switch (nargs) {
      case 7:
	err_flag = 1;
        str = GetString(6);
        if(str == NULL)
          return 2; /* illegal parameter */
        strcpy(err_file, str);
	/* through */
      case 6:
	teach_flag = 1;
        str = GetString(5);
        if(str == NULL)
          return 2; /* illegal parameter */
	strcpy(teach_file, str);
	/* through */
      case 5:
	bps_cont.MaxScale    = (float)GetScalar(4);
	/* through */
      case 4:
	bps_cont.MinScale    = (float)GetScalar(3);
	break;
      }
    }
    if ((bps_cont.DisplayMode != BPS_TRACEMODE_COLOR) &&
	(bps_cont.DisplayMode != BPS_TRACEMODE_SIZE) &&
	(bps_cont.DisplayMode != BPS_TRACEMODE_NETWORK_FUNCTION) &&
	(bps_cont.DisplayMode != BPS_TRACEMODE_NETWORK_ONLY))
      return 45; /* Illigal Parameter 3 */
  }
  GetStructureParameters();
  PrintStructureParameters();
  GetTestingParameters();
  PrintTestingParameters();

  if (disp_flag) {
    if(regpm() == -1)
      return 2; /* Illigal Parameter */
    
    /* if (checktodvi())
      writegpm(); */
    gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, 
			GpmCont.paperWidth, GpmCont.paperHeight);
    gnewpen(GpmCont.fColor);
    gpen(GpmCont.fLineWidth,GpmCont.fLineType, 0);
    gorigin(GpmCont.xOrigin, GpmCont.yOrigin);
    gfactor(GpmCont.factor);
  } else
    bps_cont.DisplayMode = (file_out_flag) ? BPS_TRACEMODE_COLOR : 5;

  /* CONSTANT DEFINE */
  switch (bps_cont.DisplayMode) {
  case BPS_TRACEMODE_NETWORK_FUNCTION:
  case BPS_TRACEMODE_NETWORK_ONLY:
    /* DRAW NETWORK STRUCTURE */
    DrawNetwork(bps_cont.DisplayMode);
    if (!file_out_flag) break;
    disp_flag = 0;

    /* through */
  case BPS_TRACEMODE_COLOR:
  case BPS_TRACEMODE_SIZE:
    /* TEST( RECOGNIZE ) AND DRAW NETWORK STRUCTURE */
    rec_system_initialize();
    MakeNetwork();
    ReadWeight2(bps_cont.TestWgtFile, bps_cont.WgtHistoryNo);

    if (file_out_flag) CreateFile1(bps_cont.ActFile,  "activation data");
    if (err_flag)      CreateFile1(err_file, "error data");

    if (disp_flag) {
      DrawNetwork(bps_cont.DisplayMode);

      if (teach_flag) {
        bps_cont.TeachData = (float**)bps_malloc2D(bps_cont.NumOfPtrn, bps_cont.NumOfCell[bps_cont.NumOfLayer-1],
				      sizeof(float));
        if (bps_cont.TeachData == NULL)
          return 42; /* Can't Allocate To \"TeachData\ */

        ReadData(teach_file, bps_cont.TeachData, bps_cont.TestFirstPtrn, bps_cont.TestLastPtrn,
              bps_cont.NumOfCell[bps_cont.NumOfLayer-1]);
        DrawTeachData();
      }
    }

    for (ptrn_no = 0; ptrn_no < bps_cont.NumOfPtrn; ptrn_no++) {
      test_network(bps_cont.InputData[ptrn_no]);

      if ((file_out_flag) || (err_flag)) {
        error = 0.0;
        for (unit_no = 1; unit_no <= bps_cont.NumOfCell[bps_cont.OutputLayer]; unit_no++) {
          cell_pt = bps_cont.BPNet[bps_cont.OutputLayer][unit_no].CellNode;
          if (file_out_flag){
            bps_cont.act_buf[unit_no - 1] = (float)cell_pt->Active;
          }
          if (err_flag) {
            err = bps_cont.TeachData[ptrn_no][unit_no-1] - (float)cell_pt->Active;
            err = err * err;	/* May 31th, 1992 Kuroda Ga
                 * Rewrite Shimashita.  */
            error += err;
            bps_cont.ErrBuffer[unit_no-1] = err;
          }
        }
        if (file_out_flag){
          WriteActivation(ptrn_no); /* suzu */
        }
      }
      if (err_flag){
        bps_cont.ErrBuffer[bps_cont.NumOfCell[bps_cont.OutputLayer]] = error;
        WriteErrRecord(err_file, ptrn_no);
      }
      if (disp_flag)
        DrawBox(ptrn_no, teach_flag, bps_cont.InputLayer, 
                bps_cont.OutputLayer, bps_cont.DisplayMode);
    } /* END OF NETWORK TEST */

    BreakNetwork();
    rec_system_end();
    break;
  } /* END OF SWITCH */

  if (disp_flag) {
    glimit(0.0, 0.0, 0.0, 0.0);
    gflush();
    gclose();
  }
  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
