/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/pinit.cpp,v 1.2 2005/02/14 07:03:41 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
 *                                               *
 *       Back Propergation Simurator             *
 *             subroutine packege                *
 *               Version 			*
 *         coded         in May.9  1990          *
 *         coded by      M.Kai                   *
 *         last modified in Jul.3  1990          *
 *         modified by   K.Kuroda                *
 *                                               *
 *************************************************
 *                                               *
 *       filename bpinit.c                       *
 *           BPS PINIT command                   *
 *                                               *
 ************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
  initialize parameters 
  ***********************************************/

DLLEXPORT int mod_bps_pinit()
{
  int  lay_no;

  /* FOR NETWORK STRUCTURE */
  bps_cont.bps_sp.NumOfLayer = 0;
  for (lay_no = 0; lay_no < BPS_MAX_LAYER; lay_no++) {
    bps_cont.bps_sp.NumOfCell[lay_no]   = 0;
    bps_cont.bps_sp.FuncBias[lay_no][0] = EOS;
  }

  /* FOR INTIALIZE WEIGHT */
  bps_cont.bps_sp.InitAlgo              = BPS_INITALGO_RANDUM;
  bps_cont.bps_sp.InitWgtFile[0]        = EOS;
  bps_cont.bps_sp.Seed                  = 1;
  bps_cont.bps_sp.MaxInitWgt            = 1.0;
  bps_cont.bps_sp.MinInitWgt            = -1.0;

  /* FOR LEARNING */
  bps_cont.bps_sp.LrnInitWgtFile[0]     = EOS;
  bps_cont.bps_sp.WgtHistoryFile[0]     = EOS;
  bps_cont.bps_sp.WgtStorInterval       = 1;
  bps_cont.bps_sp.WgtStorMode           = BPS_STOREMODE_APPEND;
  bps_cont.bps_sp.ErrHistoryFile[0]     = EOS;
  bps_cont.bps_sp.ErrStorInterval       = 1;
  bps_cont.bps_sp.ErrStorDirection      = BPS_STOREDIR_RECORD;
  bps_cont.bps_sp.ErrStorMode           = BPS_STOREMODE_APPEND;
  bps_cont.bps_sp.InputFile[0]          = EOS;
  bps_cont.bps_sp.TeachFile[0]          = EOS;
  bps_cont.bps_sp.LrnFirstPtrn          = 0;
  bps_cont.bps_sp.LrnLastPtrn           = 0;
  bps_cont.bps_sp.LearnMode             = BPS_LEARNMODE_SET;
  bps_cont.bps_sp.LearnAlgo             = BPS_LEARNALGO_MOMENTUM;
  bps_cont.bps_sp.LearnRate             = 0.0;
  bps_cont.bps_sp.Momentum              = 0.0;
  bps_cont.bps_sp.IncreaseFact          = 0.0;
  bps_cont.bps_sp.ReductFact            = 0.0;
  bps_cont.bps_sp.VoglThresh            = 0.0;
  bps_cont.bps_sp.Theta                 = 0.0;
  bps_cont.bps_sp.MinError              = 0.0;
  bps_cont.bps_sp.MaxLearnCount         = 0;
  bps_cont.bps_sp.DisplayInterval       = 0;
  bps_cont.bps_sp.Comment[0]            = EOS;

  /* FOR TEST */
  bps_cont.bps_sp.TestWgtFile[0]        = EOS;
  bps_cont.bps_sp.WgtHistoryNo          = 0;
  bps_cont.bps_sp.TestFile[0]           = EOS;
  bps_cont.bps_sp.TestFirstPtrn         = 0;
  bps_cont.bps_sp.TestLastPtrn          = 0;
  bps_cont.bps_sp.InputLayer            = 0;
  bps_cont.bps_sp.OutputLayer           = 0;
  bps_cont.bps_sp.ActFile[0]            = EOS;

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif