/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/pdisp.cpp,v 1.3 2005/02/15 09:43:05 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			*
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename pdisp.c                        *
*           BPS DISP command                    *
*                                               *
************************************************/

/***********************************************
  display parameters  
  ***********************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_bps_pdisp()
{
  int  lay_no;

  rebps();

  printf("\n\n<<  structure of network  >>\n");
  printf("### Number of layer = %d\n", bps_cont.bps_sp.NumOfLayer);
  printf("    layer     num of cells        condition\n");

  for (lay_no = 0; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++) {
    printf("       %2d        %5d", lay_no, bps_cont.bps_sp.NumOfCell[lay_no]);

    switch (bps_cont.bps_sp.FuncBias[lay_no][0]) {
    case BPS_BIAS_SIGMOID:   printf("         sigmoid,"); break;
    case BPS_BIAS_LINEAR:    printf("         linear ,"); break;
    default:                                     break;
    }
    switch (bps_cont.bps_sp.FuncBias[lay_no][1]) {
    case BPS_STOREMODE_APPEND:    printf(" append bias\n");    break;
    case BPS_STOREMODE_NO_APPEND: printf(" non bias\n");       break;
    default:        printf("\n");
    }
  }

  printf("\n\n<<  Initialize condition  >>\n");
  printf("### Initialize algorithm      = ");

  switch (bps_cont.bps_sp.InitAlgo) {
  case BPS_INITALGO_RANDUM:      printf("randum\n");          break;
  case BPS_INITALGO_JIA:         printf("Jia's algorithm\n"); break;
  default:          printf("\n");
  }

  printf("### Initialize data file name = %s\n", bps_cont.bps_sp.InitWgtFile);
  printf("    Seed     Max Weight     Min Weight\n");
  printf("  %6d          %g             %g\n",
	 bps_cont.bps_sp.Seed, bps_cont.bps_sp.MaxInitWgt, bps_cont.bps_sp.MinInitWgt);

  printf("\n\n<<  Learning condition  >>\n");
  printf("### Initialize data file name = %s\n", bps_cont.bps_sp.LrnInitWgtFile);
  printf("### Weight history file name  = %s\n", bps_cont.bps_sp.WgtHistoryFile);
  printf("    Store   Interval     Mode\n");
  printf("             %5d      ", bps_cont.bps_sp.WgtStorInterval);
  switch (bps_cont.bps_sp.WgtStorMode) {
  case BPS_STOREMODE_APPEND:
    printf("append\n");
    break;
  case BPS_STOREMODE_OVERWRITE:
    printf("overwrite\n");
    break;
  default:
    printf("\n");
  }

  printf("### Error history file name = %s\n", bps_cont.bps_sp.ErrHistoryFile);
  printf("    Store   Interval   Direction");
  if (bps_cont.bps_sp.ErrStorDirection == BPS_STOREDIR_RECORD) printf("     mode\n");
  else                                   printf("\n");

  printf("             %5d     ", bps_cont.bps_sp.ErrStorInterval);
  switch (bps_cont.bps_sp.ErrStorDirection) {
  case BPS_STOREDIR_RECORD:
    printf(" record      ");
    switch (bps_cont.bps_sp.ErrStorMode) {
    case BPS_STOREMODE_APPEND:     printf("append\n");    break;
    case BPS_STOREMODE_OVERWRITE:  printf("ovarwrite\n"); break;
    default:         printf("\n");
    }
    break;
  case BPS_STOREDIR_DATAPOINT:
    printf("data point\n");
    break;
  default:
    printf("\n");
  }

  printf("### Input data file name = %s\n", bps_cont.bps_sp.InputFile);
  printf("### Teach data file name = %s\n", bps_cont.bps_sp.TeachFile);
  printf("    Input pattern number = ");
  if (bps_cont.bps_sp.LrnFirstPtrn == 0)
    printf("all\n");
  else
    printf("%d -> %d\n", bps_cont.bps_sp.LrnFirstPtrn, bps_cont.bps_sp.LrnLastPtrn);

  printf("### Learning mode 	 = ");
  switch (bps_cont.bps_sp.LearnMode){
  case BPS_LEARNMODE_SET:      printf("set learning\n");     break;
  case BPS_LEARNMODE_PATTERN:  printf("pattern learning\n"); break;
  default:             printf("\n");
  }

  printf("### Learning algorithm  = ");
  switch (bps_cont.bps_sp.LearnAlgo) {
  case BPS_LEARNALGO_STEEP:      printf("Steep method\n");     break;
  case BPS_LEARNALGO_MOMENTUM:   printf("Momentum method\n");  break;
  case BPS_LEARNALGO_VOGL:       printf("Vogl method\n");      break;
  case BPS_LEARNALGO_JACOB:      printf("Jacob's method\n");   break;
  case BPS_LEARNALGO_MOMENTUM2:  printf("Momentum Vogl's coefficient method\n"); break;
  case BPS_LEARNALGO_OCHI:       printf("Ochiai's method\n");  break;
  default:         printf("\n");
  }

  if ((bps_cont.bps_sp.LearnAlgo >= BPS_LEARNALGO_STEEP) && (bps_cont.bps_sp.LearnAlgo <= BPS_LEARNALGO_OCHI))
    printf("    Learning rate = %g\n", bps_cont.bps_sp.LearnRate);

  if ((bps_cont.bps_sp.LearnAlgo >= BPS_LEARNALGO_MOMENTUM) && (bps_cont.bps_sp.LearnAlgo <= BPS_LEARNALGO_OCHI))
    printf("    Momentum      = %g\n", bps_cont.bps_sp.Momentum);

  if (bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_VOGL  ||
      bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_JACOB ||
      bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_OCHI) {
    printf("    Increasing factor rate = %g\n", bps_cont.bps_sp.IncreaseFact);
    printf("    Reduction factor rate  = %g\n", bps_cont.bps_sp.ReductFact);
  }

  if (bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_VOGL)
    printf("    Threshold for Vogl method = %g\n", bps_cont.bps_sp.VoglThresh);

  if (bps_cont.bps_sp.LearnAlgo == BPS_LEARNALGO_OCHI)
    printf("    Theta(for Ochiai's method) = %g\n", bps_cont.bps_sp.Theta);

  printf("### Minimum error for end     = %g\n", bps_cont.bps_sp.MinError);
  printf("### Maximum iteration for end = %d\n", bps_cont.bps_sp.MaxLearnCount);

  printf("### Display interval = %d\n", bps_cont.bps_sp.DisplayInterval);
  printf("### Comment = %s\n", bps_cont.bps_sp.Comment);

  printf("\n\n<<  Testing condition  >>\n");
  printf("### Weight file for test = %s\n", bps_cont.bps_sp.TestWgtFile);
  printf("### Weight history number = %d\n", bps_cont.bps_sp.WgtHistoryNo);
  printf("### Input data file for test = %s\n", bps_cont.bps_sp.TestFile);
  printf("    Input pattern number     = ");

  if (bps_cont.bps_sp.TestFirstPtrn == 0) {
    printf("all\n");
  } else
    printf("%d -> %d\n", bps_cont.bps_sp.TestFirstPtrn, bps_cont.bps_sp.TestLastPtrn);

  printf("### Input layer  = %d\n", bps_cont.bps_sp.InputLayer);
  printf("### Output layer = %d\n", bps_cont.bps_sp.OutputLayer);
  printf("### Result file for test     = %s\n", bps_cont.bps_sp.ActFile);
 /* appending StuctureLearning param */
 /* modified  by higashi */
  printf("### Checking New Param ### \n");
  printf("### StrLrnMode = %d\n",bps_cont.bps_sp.StrLrnMode);
  printf("### PruRamuda  = %g\n",bps_cont.bps_sp.Ramuda);
 /*-------end of modified -----------*/
  
  return 0;
}

#ifdef __cplusplus
}
#endif