/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/layer.cpp,v 1.4 2005/02/22 07:39:54 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version 			                  *
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename nlay.c                         *
*           BPS LAYER command                   *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************
	get number of layer and units parameters   
***********************************************/
DLLEXPORT int mod_bps_layer()
{
  char  rem[100];
  int   lay_no, num_cell;
  int   nargs;

  rebps();

  nargs = GetArgNum();

  bps_cont.bps_sp.NumOfLayer = (int)GetScalar(0);
  if ((bps_cont.bps_sp.NumOfLayer > BPS_MAX_LAYER) ||
      (bps_cont.bps_sp.NumOfLayer < 0))
    return 211; /* Illigal Parameter( Number Of Layer ) */

  for (lay_no = 0; lay_no < nargs-1; lay_no++)
    bps_cont.bps_sp.NumOfCell[lay_no] = (int)GetScalar(lay_no+1);

  if (nargs <= bps_cont.bps_sp.NumOfLayer) {
    for (lay_no = nargs - 1; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++) {
      printf("\tLayer%2d = %d\t", lay_no, bps_cont.bps_sp.NumOfCell[lay_no]);

      if (fgets(rem, 100, stdin) != NULL) {
        sscanf(rem, "%d", &num_cell);
        bps_cont.bps_sp.NumOfCell[lay_no] = num_cell;
      }
    }
  }

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
