/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/function.cpp,v 1.3 2005/02/21 11:53:13 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version                         *
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.2  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpinit.c                       *
*           BPS FUNCTION command                *
*                                               *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

static int check_bias_type(char func_bias[4]);

static int check_bias_type(char func_bias[4])
{
  int  i;
  
  func_bias[3] = '\0';
  for (i = 0; i < 2; i++)
    func_bias[i] = toupper(func_bias[i]);

  if (strcmp("LN", func_bias) == 0 ||
      strcmp("LA", func_bias) == 0 ||
      strcmp("SN", func_bias) == 0 ||
      strcmp("SA", func_bias) == 0 ) return 0;

  return -1;
}


/***********************************************
        get function and bias parameters
***********************************************/
DLLEXPORT int mod_bps_function()
{
  char    rem[100], func_bias[5];
  int     lay_no;
  int     nargs;

  rebps();

  nargs = GetArgNum();

  if (bps_cont.bps_sp.NumOfLayer <= 0)
		return 209; /* Set Number Of Layer */

  for (lay_no = 0; lay_no < nargs; lay_no++) {
    strncpy(func_bias, GetString(lay_no), 4);

    if (check_bias_type( func_bias ) != 0)
      return 208; /* Unknown Function Or Bias */

    strcpy(bps_cont.bps_sp.FuncBias[lay_no], func_bias);
  }

  if (nargs < bps_cont.bps_sp.NumOfLayer) {
    for (lay_no = nargs; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++) {
      printf("\tLayer%2d = %2s\t", lay_no, bps_cont.bps_sp.FuncBias[lay_no]);

      if ((fgets(rem, 100, stdin) != NULL) && (strlen(rem) >= 2)) {
        sscanf(rem, "%2s", func_bias);

        if (check_bias_type( func_bias ) != 0)
          return 208; /* Unknown Function Or Bias */

        strcpy(bps_cont.bps_sp.FuncBias[lay_no], func_bias);
      }
    }
  }

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
